/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Sink;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageProducer;

public class VideoSink
extends Sink {
    private Component component;
    private boolean keepAspect = true;
    private Frame frame;
    private int width;
    private int height;
    private int aspect_x;
    private int aspect_y;

    protected boolean setCapsFunc(Caps caps) {
        String string = caps.getMime();
        if (!string.equals("video/raw")) {
            return false;
        }
        this.width = caps.getFieldInt("width", -1);
        this.height = caps.getFieldInt("height", -1);
        if (this.width == -1 || this.height == -1) {
            return false;
        }
        this.aspect_x = caps.getFieldInt("aspect_x", 1);
        this.aspect_y = caps.getFieldInt("aspect_y", 1);
        if (this.aspect_y > this.aspect_x) {
            this.height = this.height * this.aspect_y / this.aspect_x;
        } else {
            this.width = this.width * this.aspect_x / this.aspect_y;
        }
        this.component.setVisible(true);
        return true;
    }

    protected int preroll(Buffer buffer) {
        return this.render(buffer);
    }

    protected int render(Buffer buffer) {
        int n;
        int n2;
        int n3;
        int n4;
        Image image;
        if (buffer.object instanceof ImageProducer) {
            image = this.component.createImage((ImageProducer)buffer.object);
        } else if (buffer.object instanceof Image) {
            image = (Image)buffer.object;
        } else {
            System.out.println(this + ": unknown buffer received " + buffer);
            return -5;
        }
        if (!this.component.isVisible()) {
            return -4;
        }
        Dimension dimension = this.component.getSize();
        Graphics graphics = this.component.getGraphics();
        if (this.keepAspect) {
            n4 = dimension.width;
            n3 = dimension.height;
            n2 = 0;
            n = 0;
        } else {
            n4 = dimension.width;
            n3 = dimension.height;
            n2 = 0;
            n = 0;
        }
        graphics.drawImage(image, n2, n, n4, n3, null);
        return 0;
    }

    public String getFactoryName() {
        return "videosink";
    }

    public boolean setProperty(String string, Object object) {
        if (string.equals("component")) {
            this.component = (Component)object;
        } else if (string.equals("keep-aspect")) {
            this.keepAspect = String.valueOf(object).equals("true");
        } else {
            return false;
        }
        return true;
    }

    public Object getProperty(String string) {
        if (string.equals("component")) {
            return this.component;
        }
        if (string.equals("keep-aspect")) {
            return this.keepAspect ? "true" : "false";
        }
        return null;
    }

    protected int changeState(int n) {
        if (this.currentState == 1 && this.pendingState == 2 && this.component == null) {
            this.frame = new Frame();
            this.component = this.frame;
        }
        return super.changeState(n);
    }
}

