/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.ElementFactory;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Base64Converter;
import com.fluendo.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HTTPSrc
extends Element {
    private static final int DEFAULT_READSIZE = 4096;
    private String userId;
    private String password;
    private String userAgent;
    private String urlString;
    private InputStream input;
    private long contentLength;
    private String mime;
    private Caps outCaps;
    private boolean discont;
    private URL documentBase;
    private int readSize;
    private Pad srcpad;

    private final InputStream openWithConnection(URL uRL, long l) throws IOException {
        InputStream inputStream = null;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Connection", "Keep-Alive");
        String string = l != 0L && this.contentLength != (long)-1 ? "bytes=" + l + '-' + (this.contentLength - 1L) : (l != 0L ? "bytes=" + l + '-' : null);
        if (string != null) {
            Debug.log(3, "doing range: " + string);
            uRLConnection.setRequestProperty("Range", string);
        }
        uRLConnection.setRequestProperty("User-Agent", this.userAgent);
        if (this.userId != null && this.password != null) {
            String string2 = this.userId + ':' + this.password;
            String string3 = Base64Converter.encode(string2.getBytes());
            uRLConnection.setRequestProperty("Authorization", "Basic " + string3);
        }
        uRLConnection.setRequestProperty("Content-Type", "application/octet-stream");
        inputStream = uRLConnection.getInputStream();
        this.contentLength = (long)uRLConnection.getHeaderFieldInt("Content-Length", 0) + l;
        this.mime = uRLConnection.getContentType();
        return inputStream;
    }

    private final InputStream openWithSocket(URL uRL, long l) throws IOException {
        InputStream inputStream = null;
        String string = uRL.getHost();
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        Socket socket = new Socket(inetAddress, n);
        String string2 = uRL.getFile();
        OutputStream outputStream = socket.getOutputStream();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GET ").append(string2).append(" HTTP/1.0\r\n");
        stringBuffer.append("Content-Type: application/octet-stream\r\n");
        stringBuffer.append("Connection: Keep-Alive\r\n");
        String string3 = l != 0L && this.contentLength != (long)-1 ? "bytes=" + l + '-' + (this.contentLength - 1L) : (l != 0L ? "bytes=" + l + '-' : null);
        if (string3 != null) {
            Debug.log(3, "doing range: " + string3);
            stringBuffer.append("Range: ").append(string3).append("\r\n");
        }
        stringBuffer.append("User-Agent: Cortado\r\n");
        if (this.userId != null && this.password != null) {
            String string4 = this.userId + ':' + this.password;
            String string5 = Base64Converter.encode(string4.getBytes());
            stringBuffer.append("Authorization: Basic ").append(string5).append("\r\n");
        }
        stringBuffer.append("\r\n\r\n");
        outputStream.write(stringBuffer.toString().getBytes());
        outputStream.flush();
        inputStream = socket.getInputStream();
        this.contentLength = 10000000L;
        this.mime = "application/ogg";
        return inputStream;
    }

    private final InputStream getInputStream(long l) throws Exception {
        InputStream inputStream = null;
        try {
            URL uRL;
            this.postMessage(Message.newResource(this, "Opening " + this.urlString));
            Debug.log(3, "reading from url " + this.urlString);
            boolean bl = this.urlString.startsWith("http://");
            if (!bl && this.documentBase != null) {
                Debug.log(3, "parsing in document base");
                uRL = new URL(this.documentBase, this.urlString);
            } else {
                Debug.log(3, "parsing as abslute URL");
                uRL = new URL(this.urlString);
            }
            Debug.log(3, "trying to open " + uRL + " at offset " + l);
            inputStream = this.openWithConnection(uRL, l);
            this.discont = true;
            Debug.log(3, "opened " + uRL);
            Debug.log(3, "contentLength: " + this.contentLength);
            Debug.log(3, "server contentType: " + this.mime);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            this.postMessage(Message.newError(this, "Not allowed " + this.urlString + "..."));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.postMessage(Message.newError(this, "Failed opening " + this.urlString + "..."));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.postMessage(Message.newError(this, "Failed opening " + this.urlString + "..."));
        }
        return inputStream;
    }

    public String getFactoryName() {
        return "httpsrc";
    }

    public synchronized boolean setProperty(String string, Object object) {
        boolean bl = true;
        if (string.equals("url")) {
            this.urlString = String.valueOf(object);
        } else if (string.equals("documentBase")) {
            this.documentBase = (URL)object;
        } else if (string.equals("userId")) {
            this.userId = String.valueOf(object);
        } else if (string.equals("userAgent")) {
            this.userAgent = String.valueOf(object);
        } else if (string.equals("password")) {
            this.password = String.valueOf(object);
        } else if (string.equals("readSize")) {
            this.readSize = Integer.parseInt((String)object);
        } else {
            bl = false;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.userAgent = "Cortado";
        this.readSize = 4096;
        this.srcpad = new Pad(1, "src"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final boolean doSeek(Event event) {
                int n = event.parseSeekFormat();
                long l = event.parseSeekPosition();
                if (n == 5 && HTTPSrc.this.contentLength != (long)-1) {
                    l = l * HTTPSrc.this.contentLength / 1000000L;
                } else if (n != 2) {
                    Debug.log(2, "can only seek in bytes");
                    return false;
                }
                Debug.log(4, this + " flushing");
                this.pushEvent(Event.newFlushStart());
                Object object = this.streamLock;
                synchronized (object) {
                    Debug.log(4, this + " synced");
                    boolean bl = false;
                    try {
                        HTTPSrc.this.input = HTTPSrc.this.getInputStream(l);
                        if (HTTPSrc.this.input != null) {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.pushEvent(Event.newFlushStop());
                    if (bl) {
                        this.pushEvent(Event.newNewsegment(false, 2, l, HTTPSrc.this.contentLength, l));
                        HTTPSrc.this.postMessage(Message.newStreamStatus(this, true, 0, "restart after seek"));
                        return this.startTask("cortado-HTTPSrc-Stream-" + Debug.genId());
                    }
                    HTTPSrc.this.postMessage(Message.newError(this, "error: Seek failed"));
                    return bl;
                }
            }

            protected final boolean eventFunc(Event event) {
                boolean bl;
                switch (event.getType()) {
                    case 5: {
                        bl = this.doSeek(event);
                        break;
                    }
                    default: {
                        bl = super.eventFunc(event);
                    }
                }
                return bl;
            }

            protected final void taskFunc() {
                Buffer buffer = Buffer.create();
                buffer.ensureSize(HTTPSrc.this.readSize);
                buffer.offset = 0;
                try {
                    buffer.length = HTTPSrc.this.input.read(buffer.data, 0, HTTPSrc.this.readSize);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    buffer.length = 0;
                }
                if (buffer.length <= 0) {
                    buffer.free();
                    Debug.log(3, this + " reached EOS");
                    this.pushEvent(Event.newEOS());
                    HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, -3, "reached EOS"));
                    this.pauseTask();
                } else {
                    if (HTTPSrc.this.srcpad.getCaps() == null) {
                        String string = ElementFactory.typeFindMime(buffer.data, buffer.offset, buffer.length);
                        if (string != null) {
                            if (!string.equals(HTTPSrc.this.mime)) {
                                Debug.log(2, "server contentType: " + HTTPSrc.this.mime + " disagrees with our typeFind: " + string);
                            }
                            Debug.log(3, "using typefind contentType: " + string);
                            HTTPSrc.this.mime = string;
                        } else {
                            Debug.log(3, "typefind failed, using server contentType: " + HTTPSrc.this.mime);
                        }
                        HTTPSrc.this.outCaps = new Caps(HTTPSrc.this.mime);
                        HTTPSrc.this.srcpad.setCaps(HTTPSrc.this.outCaps);
                    }
                    buffer.caps = HTTPSrc.this.outCaps;
                    buffer.setFlag(1, HTTPSrc.this.discont);
                    HTTPSrc.this.discont = false;
                    int n = this.push(buffer);
                    if (n != 0) {
                        if (1.isFlowFatal(n) || n == -1) {
                            HTTPSrc.this.postMessage(Message.newError(this, "error: " + 1.getFlowName(n)));
                            this.pushEvent(Event.newEOS());
                        }
                        HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, n, "reason: " + 1.getFlowName(n)));
                        this.pauseTask();
                    }
                }
            }

            protected final boolean activateFunc(int n) {
                boolean bl = true;
                switch (n) {
                    case 0: {
                        HTTPSrc.this.postMessage(Message.newStreamStatus(this, false, -2, "stopping"));
                        bl = this.stopTask();
                        HTTPSrc.this.input = null;
                        HTTPSrc.this.outCaps = null;
                        HTTPSrc.this.mime = null;
                        break;
                    }
                    case 1: {
                        try {
                            HTTPSrc.this.contentLength = -1;
                            HTTPSrc.this.input = HTTPSrc.this.getInputStream(0L);
                            if (HTTPSrc.this.input == null) {
                                bl = false;
                            }
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                        if (!bl) break;
                        HTTPSrc.this.postMessage(Message.newStreamStatus(this, true, 0, "activating"));
                        bl = this.startTask("cortado-HTTPSrc-Stream-" + Debug.genId());
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }
        };
    }

    public HTTPSrc() {
        this.this();
        this.addPad(this.srcpad);
    }
}

