/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Message;
import com.fluendo.plugin.AudioSink;
import com.fluendo.utils.Debug;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AudioSinkJ2
extends AudioSink {
    public static final int SEGSIZE = 8192;
    private SourceDataLine line;
    private int channels;
    private long samplesWritten;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    protected AudioSink.RingBuffer createRingBuffer() {
        return new AudioSink.RingBuffer();
    }

    protected boolean open(AudioSink.RingBuffer ringBuffer) {
        this.channels = ringBuffer.channels;
        AudioFormat audioFormat = new AudioFormat(ringBuffer.rate, 16, ringBuffer.channels, true, true);
        Class clazz = class$javax$sound$sampled$SourceDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$SourceDataLine = AudioSinkJ2.class("[Ljavax.sound.sampled.SourceDataLine;", false);
        }
        DataLine.Info info = new DataLine.Info(clazz, audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
            this.postMessage(Message.newError(this, "Could not open audio device."));
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.postMessage(Message.newError(this, "Unknown problem opening audio device"));
            return false;
        }
        Debug.log(3, "line info: available: " + this.line.available());
        Debug.log(3, "line info: buffer: " + this.line.getBufferSize());
        Debug.log(3, "line info: framePosition: " + this.line.getFramePosition());
        ringBuffer.segSize = 8192;
        ringBuffer.segTotal = this.line.getBufferSize() / ringBuffer.segSize;
        while (ringBuffer.segTotal < 4) {
            ringBuffer.segSize >>= 1;
            ringBuffer.segTotal = this.line.getBufferSize() / ringBuffer.segSize;
        }
        ringBuffer.emptySeg = new byte[ringBuffer.segSize];
        this.samplesWritten = 0L;
        this.line.start();
        return true;
    }

    protected boolean close(AudioSink.RingBuffer ringBuffer) {
        this.line.stop();
        this.line.close();
        return true;
    }

    protected int write(byte[] byArray, int n, int n2) {
        int n3 = this.line.write(byArray, n, n2);
        this.samplesWritten += (long)(n3 / (2 * this.channels));
        return n3;
    }

    protected long delay() {
        int n = this.line.getFramePosition();
        long l = this.samplesWritten - (long)n;
        return l;
    }

    protected void reset() {
        Debug.log(4, "reset audio: " + this.line);
        this.line.flush();
        this.samplesWritten = this.line.getFramePosition();
        Debug.log(4, "samples written: " + this.samplesWritten);
    }

    public String getFactoryName() {
        return "audiosinkj2";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.line = null;
    }

    public AudioSinkJ2() {
        this.this();
    }
}

