/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Clock;
import com.fluendo.jst.ClockProvider;
import com.fluendo.jst.Event;
import com.fluendo.jst.Sink;
import com.fluendo.jst.SystemClock;
import com.fluendo.utils.Debug;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AudioSink
extends Sink
implements ClockProvider {
    protected RingBuffer ringBuffer;
    private AudioClock audioClock;

    public Clock provideClock() {
        return this.audioClock;
    }

    protected int doSync(long l) {
        return 0;
    }

    protected boolean doEvent(Event event) {
        switch (event.getType()) {
            case 1: {
                this.ringBuffer.setFlushing(true);
                break;
            }
            case 2: {
                this.ringBuffer.setFlushing(false);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    protected int render(Buffer buffer) {
        long l;
        if (buffer.isFlagSet(1)) {
            this.ringBuffer.nextSample = -1;
        }
        if ((l = buffer.timestamp - this.segStart) < 0L) {
            return 0;
        }
        long l2 = (l += this.baseTime) * (long)this.ringBuffer.rate / 1000000L;
        this.ringBuffer.commit(buffer.data, l2, buffer.offset, buffer.length);
        return 0;
    }

    protected boolean setCapsFunc(Caps caps) {
        this.ringBuffer.release();
        boolean bl = this.ringBuffer.acquire(caps);
        return bl;
    }

    protected int changeState(int n) {
        switch (n) {
            case 18: {
                this.ringBuffer = this.createRingBuffer();
                this.ringBuffer.setFlushing(false);
                break;
            }
            case 35: {
                this.ringBuffer.setAutoStart(true);
                break;
            }
            case 50: {
                this.reset();
                this.ringBuffer.setAutoStart(false);
                this.ringBuffer.pause();
                break;
            }
            case 33: {
                this.ringBuffer.setFlushing(true);
                break;
            }
        }
        int n2 = super.changeState(n);
        if (n == 33) {
            this.ringBuffer.release();
        }
        return n2;
    }

    protected abstract RingBuffer createRingBuffer();

    protected abstract boolean open(RingBuffer var1);

    protected abstract boolean close(RingBuffer var1);

    protected abstract int write(byte[] var1, int var2, int var3);

    protected abstract long delay();

    protected abstract void reset();

    private final /* synthetic */ void this() {
        this.ringBuffer = null;
        this.audioClock = new AudioClock();
    }

    public AudioSink() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class RingBuffer
    implements Runnable {
        private static final int STOP = 0;
        private static final int PAUSE = 1;
        private static final int PLAY = 2;
        protected byte[] buffer;
        private int state;
        private Thread thread;
        private long nextSample;
        private boolean flushing;
        private boolean autoStart;
        private boolean opened;
        public int bps;
        public int sps;
        public byte[] emptySeg;
        public long playSeg;
        public int segTotal;
        public int segSize;
        public int rate;
        public int channels;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            boolean bl = true;
            while (bl) {
                RingBuffer ringBuffer;
                block12: {
                    ringBuffer = this;
                    // MONITORENTER : ringBuffer
                    {
                        if (this.state == 2) break block12;
                        while (this.state == 1) {
                            try {
                                this.notifyAll();
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (this.state != 0) break block12;
                        bl = false;
                        // MONITOREXIT : ringBuffer
                        return;
                    }
                }
                int n = (int)(this.playSeg % (long)this.segTotal);
                int n2 = n * this.segSize;
                int n3 = this.segSize;
                while (n3 > 0) {
                    int n4 = AudioSink.this.write(this.buffer, n2, this.segSize);
                    if (n4 == -1) break;
                    n3 -= n4;
                }
                this.clear(n);
                ringBuffer = this;
                // MONITORENTER : ringBuffer
                ++this.playSeg;
                this.notifyAll();
                // MONITOREXIT : ringBuffer
            }
        }

        public synchronized void setFlushing(boolean bl) {
            this.flushing = bl;
            this.clearAll();
            if (bl) {
                this.pause();
            }
        }

        protected void startWriteThread() {
            this.thread = new Thread(this);
            this.thread.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }

        public synchronized boolean acquire(Caps caps) {
            if (this.thread != null) {
                return false;
            }
            if (this.opened) {
                return false;
            }
            String string = caps.getMime();
            if (!string.equals("audio/raw")) {
                return false;
            }
            this.rate = caps.getFieldInt("rate", 44100);
            this.channels = caps.getFieldInt("channels", 1);
            this.bps = 2 * this.channels;
            boolean bl = AudioSink.this.open(this);
            if (!bl) {
                return bl;
            }
            this.opened = true;
            Debug.log(3, "audio: segSize: " + this.segSize);
            Debug.log(3, "audio: segTotal: " + this.segTotal);
            ++this.segTotal;
            this.buffer = new byte[this.segSize * this.segTotal];
            this.sps = this.segSize / this.bps;
            this.state = 1;
            this.nextSample = 0L;
            this.playSeg = 0L;
            this.startWriteThread();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean release() {
            this.stop();
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                if (this.opened && !AudioSink.this.close(this)) {
                    return false;
                }
                this.opened = false;
                return true;
            }
        }

        private final synchronized boolean waitSegment() {
            if (this.flushing) {
                return false;
            }
            if (this.state != 2 && this.autoStart) {
                this.play();
            }
            try {
                if (this.state != 2) {
                    return false;
                }
                this.wait();
                if (this.flushing) {
                    return false;
                }
                if (this.state != 2) {
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public int commit(byte[] byArray, long l, int n, int n2) {
            if (l == (long)-1) {
                l = this.nextSample;
            }
            if (l < 0L) {
                return n2;
            }
            if (this.nextSample != (long)-1) {
                if (Math.abs(l - this.nextSample) < (long)(this.rate / 10)) {
                    l = this.nextSample;
                } else {
                    System.out.println("discont: found " + l + " expected " + this.nextSample);
                }
            }
            int n3 = 0;
            this.nextSample = l + (long)(n2 / this.bps);
            while (n2 > 0) {
                int n4;
                long l2;
                long l3;
                int n5;
                block12: {
                    n5 = 0;
                    l3 = -1;
                    l2 = l / (long)this.sps;
                    n4 = (int)(l % (long)this.sps * (long)this.bps);
                    do {
                        block11: {
                            RingBuffer ringBuffer = this;
                            // MONITORENTER : ringBuffer
                            {
                                l3 = l2 - this.playSeg;
                                // MONITOREXIT : ringBuffer
                                if (l3 >= 0L) break block11;
                            }
                            n5 = Math.min(this.segSize, n2);
                            break block12;
                        }
                        if (l3 < (long)this.segTotal) break block12;
                    } while (this.waitSegment());
                    return -1;
                }
                if (l3 >= 0L) {
                    int n6 = (int)(l2 % (long)this.segTotal);
                    n5 = Math.min(this.segSize - n4, n2);
                    System.arraycopy(byArray, n3, this.buffer, n6 * this.segSize + n4, n5);
                }
                n2 -= n5;
                n3 += n5;
                l += (long)(n5 / this.bps);
            }
            return n2;
        }

        public synchronized long samplesPlayed() {
            long l = AudioSink.this.delay();
            long l2 = Math.max(0L, this.playSeg - 1L);
            long l3 = l2 * (long)this.sps;
            l3 = l3 >= l ? (l3 -= l) : 0L;
            return l3;
        }

        public synchronized void clear(long l) {
            int n = (int)(l % (long)this.segTotal) * this.segSize;
            System.arraycopy(this.emptySeg, 0, this.buffer, n, this.segSize);
        }

        public synchronized void clearAll() {
            int n = 0;
            while (n < this.segTotal) {
                this.clear(n);
                ++n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void setSample(long l) {
            if (l == (long)-1) {
                l = 0L;
            }
            this.playSeg = l / (long)this.sps;
            this.nextSample = l;
            this.clearAll();
            AudioClock audioClock = AudioSink.this.audioClock;
            synchronized (audioClock) {
                AudioSink.this.audioClock.notifyAll();
                return;
            }
        }

        public synchronized void setAutoStart(boolean bl) {
            this.autoStart = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean play() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                if (this.flushing) {
                    return false;
                }
                this.state = 2;
                this.notifyAll();
                AudioSink.this.audioClock.setStarted(true);
                Debug.log(4, this + " playing");
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean pause() {
            RingBuffer ringBuffer = this;
            synchronized (ringBuffer) {
                this.state = 1;
                Debug.log(4, this + " pausing");
                this.notifyAll();
                if (this.thread != null) {
                    try {
                        Debug.log(4, this + " waiting for pause");
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                AudioSink.this.audioClock.setStarted(false);
            }
            Debug.log(4, this + " paused");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean stop() {
            block5: {
                RingBuffer ringBuffer = this;
                synchronized (ringBuffer) {
                    this.state = 0;
                    Debug.log(4, this + " stopping");
                    this.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (this.thread == null) break block5;
                }
                try {
                    Debug.log(4, this + " joining thread");
                    this.thread.join();
                    this.thread = null;
                }
                catch (InterruptedException interruptedException) {}
            }
            AudioSink.this.audioClock.setStarted(false);
            Debug.log(4, this + " stopped");
            return true;
        }

        public synchronized int getState() {
            return this.state;
        }

        static /* synthetic */ long access$0(RingBuffer ringBuffer) {
            return ringBuffer.nextSample;
        }

        protected RingBuffer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AudioClock
    extends SystemClock {
        private long lastTime;
        private long diff;
        private boolean started;

        public synchronized void setStarted(boolean bl) {
            this.started = bl;
            if (this.started) {
                this.diff = -1;
                this.lastTime = -1;
            }
        }

        protected synchronized long getInternalTime() {
            long l;
            if (AudioSink.this.ringBuffer == null || AudioSink.this.ringBuffer.rate == 0) {
                return 0L;
            }
            long l2 = AudioSink.this.ringBuffer.samplesPlayed();
            long l3 = l2 * 1000000L / (long)AudioSink.this.ringBuffer.rate;
            if (this.started) {
                long l4 = System.currentTimeMillis() * 1000L;
                if (this.diff == (long)-1) {
                    this.diff = l4;
                }
                if (l3 != this.lastTime) {
                    this.lastTime = l3;
                    this.diff = l4 - l3;
                }
                l = l4 - this.diff;
            } else {
                l = l3;
            }
            return l;
        }

        private final /* synthetic */ void this() {
            this.lastTime = -1;
            this.diff = -1;
            this.started = false;
        }

        private AudioClock() {
            this.this();
        }
    }
}

