/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.StatusListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Status
extends Component
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final int NONE = 0;
    private static final int BUTTON1 = 1;
    private static final int BUTTON2 = 2;
    private static final int SEEKER = 3;
    private static final int SEEKBAR = 4;
    private static final int SEEK_END = 60;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_PLAYING = 2;
    private int bufferPercent;
    private boolean buffering;
    private String message;
    private String error;
    private Rectangle r;
    private Component component;
    private Font font;
    private boolean haveAudio;
    private boolean havePercent;
    private boolean seekable;
    private int clicked;
    private Color button1Color;
    private Color button2Color;
    private Color seekColor;
    private int state;
    private double position;
    private long time;
    private double duration;
    private String speaker;
    private Image speakerImg;
    private Vector listeners;

    public void addStatusListener(StatusListener statusListener) {
        this.listeners.addElement(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.listeners.remove(statusListener);
    }

    public void notifyNewState(int n) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((StatusListener)enumeration.nextElement()).newState(n);
        }
    }

    public void notifySeek(double d) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((StatusListener)enumeration.nextElement()).newSeek(d);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private final void paintBox(Graphics graphics) {
        graphics.setColor(Color.darkGray);
        graphics.drawRect(0, 0, this.r.width - 1, this.r.height - 1);
        graphics.setColor(Color.black);
        graphics.fillRect(1, 1, this.r.width - 2, this.r.height - 2);
    }

    private final void paintPercent(Graphics graphics) {
        if (this.havePercent) {
            graphics.setColor(Color.white);
            graphics.drawString("" + this.bufferPercent + '%', this.r.width - 38, this.r.height - 2);
        }
    }

    private final void paintPlayPause(Graphics graphics) {
        int n = 1;
        int n2 = 1;
        int n3 = this.r.height - 2;
        int n4 = this.r.height - 2;
        graphics.setColor(Color.darkGray);
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(this.button1Color);
        graphics.fillRect(n + 1, n2 + 1, n3 - 1, n4 - 1);
        if (this.state == 2) {
            graphics.setColor(Color.white);
            graphics.fillRect((int)((double)n3 * 0.4), (int)((double)n4 * 0.4), (int)((double)n3 * 0.2), (int)((double)n4 * 0.5));
            graphics.fillRect((int)((double)n3 * 0.7), (int)((double)n4 * 0.4), (int)((double)n3 * 0.2), (int)((double)n4 * 0.5));
        } else {
            int[] nArray = new int[]{(int)((double)n3 * 0.4), (int)((double)n3 * 0.4), (int)((double)n3 * 0.9)};
            int[] nArray2 = new int[]{(int)((double)n3 * 0.3), (int)((double)n3 * 0.9), (int)((double)n3 * 0.6)};
            graphics.setColor(Color.white);
            graphics.fillPolygon(nArray, nArray2, 3);
        }
    }

    private final void paintStop(Graphics graphics) {
        int n = this.r.height + 1;
        int n2 = 1;
        int n3 = this.r.height - 2;
        int n4 = this.r.height - 2;
        graphics.setColor(Color.darkGray);
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(this.button2Color);
        graphics.fillRect(n + 1, n2 + 1, n3 - 1, n4 - 1);
        graphics.setColor(Color.white);
        graphics.fillRect(this.r.height + (int)((double)n3 * 0.4), (int)((double)n3 * 0.4), (int)((double)n3 * 0.5), (int)((double)n3 * 0.5));
    }

    private final void paintMessage(Graphics graphics, int n) {
        if (this.message != null) {
            graphics.setColor(Color.white);
            graphics.drawString(this.message, n, this.r.height - 2);
        }
    }

    private final void paintBuffering(Graphics graphics, int n) {
        graphics.setColor(Color.white);
        graphics.drawString("Buffering", n, this.r.height - 2);
    }

    private final void paintSeekBar(Graphics graphics) {
        int n = this.r.width - 60 - this.r.height * 2;
        int n2 = this.r.height * 2 + 1;
        graphics.setColor(Color.darkGray);
        graphics.drawRect(n2, 2, n, this.r.height - 4);
        int n3 = (int)((double)n * this.position);
        graphics.setColor(Color.gray);
        graphics.fillRect(n2 + 2, 5, n3, this.r.height - 9);
        graphics.setColor(Color.white);
        graphics.drawLine(n3 + n2 + 1, 1, n3 + n2 + 7, 1);
        graphics.drawLine(n3 + n2 + 1, this.r.height - 1, n3 + n2 + 7, this.r.height - 1);
        graphics.drawLine(n3 + n2, 2, n3 + n2, this.r.height - 2);
        graphics.drawLine(n3 + n2 + 8, 2, n3 + n2 + 8, this.r.height - 2);
        graphics.setColor(this.seekColor);
        graphics.fillRect(n3 + n2 + 1, 2, 7, this.r.height - 3);
    }

    private final void paintTime(Graphics graphics) {
        if (this.time < 0L) {
            return;
        }
        long l = this.time % 60L;
        long l2 = this.time / 60L;
        long l3 = l2 / 60L;
        this.r = this.getBounds();
        int n = this.r.width - 50;
        graphics.setColor(Color.white);
        graphics.drawString("" + l3 + ':' + ((l2 %= 60L) < 10L ? "0" + l2 : "" + l2) + ':' + (l < 10L ? "0" + l : "" + l), n, this.r.height - 2);
    }

    private final void paintSpeaker(Graphics graphics) {
        if (this.haveAudio) {
            graphics.drawImage(this.speakerImg, this.r.width - 12, this.r.height - 11, null);
        }
    }

    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.r = this.getBounds();
        Image image = this.component.createImage(this.r.width, this.r.height);
        if (image == null) {
            return;
        }
        Graphics graphics2 = image.getGraphics();
        if (graphics2 == null) {
            return;
        }
        graphics2.setFont(this.font);
        this.paintBox(graphics2);
        if (this.seekable) {
            this.paintPlayPause(graphics2);
            this.paintStop(graphics2);
            if (this.buffering) {
                this.paintPercent(graphics2);
                this.paintBuffering(graphics2, this.r.height * 2 + 3);
            } else if (this.state == 0) {
                this.paintMessage(graphics2, this.r.height * 2 + 3);
            } else {
                this.paintSeekBar(graphics2);
                this.paintTime(graphics2);
            }
        } else if (this.buffering) {
            this.paintBuffering(graphics2, 2);
            this.paintPercent(graphics2);
        } else {
            this.paintMessage(graphics2, 2);
            this.paintTime(graphics2);
        }
        this.paintSpeaker(graphics2);
        graphics.drawImage(image, this.r.x, this.r.y, null);
        image.flush();
    }

    public void setBufferPercent(boolean bl, int n) {
        this.buffering = bl;
        this.bufferPercent = n;
        this.component.repaint();
    }

    public void setTime(double d) {
        if (this.clicked == 0) {
            this.time = d < this.duration ? (long)d : (long)this.duration;
            this.position = (double)this.time / this.duration;
            this.component.repaint();
        }
    }

    public void setDuration(double d) {
        this.duration = d;
        this.component.repaint();
    }

    public void setMessage(String string) {
        this.message = string;
        this.component.repaint();
    }

    public void setHaveAudio(boolean bl) {
        this.haveAudio = bl;
        this.component.repaint();
    }

    public void setHavePercent(boolean bl) {
        this.havePercent = bl;
        this.component.repaint();
    }

    public void setSeekable(boolean bl) {
        this.seekable = bl;
        this.component.repaint();
    }

    public void setState(int n) {
        this.state = n;
        this.component.repaint();
    }

    private final boolean intersectButton1(MouseEvent mouseEvent) {
        if (this.r == null) {
            return false;
        }
        boolean bl = false;
        if (mouseEvent.getX() >= 0 && mouseEvent.getX() <= this.r.height - 2 && mouseEvent.getY() > 0 && mouseEvent.getY() <= this.r.height - 2) {
            bl = true;
        }
        return bl;
    }

    private final boolean intersectButton2(MouseEvent mouseEvent) {
        if (this.r == null) {
            return false;
        }
        boolean bl = false;
        if (mouseEvent.getX() >= this.r.height && mouseEvent.getX() <= this.r.height + this.r.height - 2 && mouseEvent.getY() > 0 && mouseEvent.getY() <= this.r.height - 2) {
            bl = true;
        }
        return bl;
    }

    private final boolean intersectSeeker(MouseEvent mouseEvent) {
        this.r = this.getBounds();
        int n = this.r.width - 60 - this.r.height * 2;
        int n2 = (int)((double)n * this.position) + this.r.height * 2 + 1;
        boolean bl = false;
        if (mouseEvent.getX() >= n2 && mouseEvent.getX() <= n2 + 9 && mouseEvent.getY() > 0 && mouseEvent.getY() <= this.r.height - 2) {
            bl = true;
        }
        return bl;
    }

    private final boolean intersectSeekbar(MouseEvent mouseEvent) {
        this.r = this.getBounds();
        int n = this.r.width - 60;
        boolean bl = false;
        if (mouseEvent.getX() >= this.r.height * 2 && mouseEvent.getX() <= n && mouseEvent.getY() > 0 && mouseEvent.getY() <= this.r.height - 2) {
            bl = true;
        }
        return bl;
    }

    private final int findComponent(MouseEvent mouseEvent) {
        if (this.intersectButton1(mouseEvent)) {
            return 1;
        }
        if (this.intersectButton2(mouseEvent)) {
            return 2;
        }
        if (this.intersectSeeker(mouseEvent)) {
            return 3;
        }
        if (this.intersectSeekbar(mouseEvent)) {
            return 4;
        }
        return 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.seekable) {
            mouseEvent.translatePoint(-1, -1);
            this.clicked = this.findComponent(mouseEvent);
            if (this.clicked == 4 && this.state != 0) {
                this.clicked = 3;
                this.seekColor = Color.gray;
                this.mouseDragged(mouseEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.seekable) {
            mouseEvent.translatePoint(-1, -1);
            int n = this.findComponent(mouseEvent);
            if (this.clicked != n) {
                if (this.clicked == 3) {
                    n = this.clicked;
                } else {
                    return;
                }
            }
            switch (n) {
                case 1: {
                    if (this.state == 2) {
                        this.state = 1;
                        this.notifyNewState(this.state);
                        break;
                    }
                    this.state = 2;
                    this.notifyNewState(this.state);
                    break;
                }
                case 2: {
                    this.state = 0;
                    this.notifyNewState(this.state);
                    break;
                }
                case 3: {
                    if (this.state == 0) break;
                    this.notifySeek(this.position);
                    break;
                }
                case 4: {
                    break;
                }
                case 0: {
                    break;
                }
            }
            this.clicked = 0;
            this.component.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.seekable) {
            mouseEvent.translatePoint(-1, -1);
            if (this.clicked == 3) {
                int n = this.r.width - 60 - this.r.height * 2;
                double d = (double)(mouseEvent.getX() - (this.r.height * 2 + 5)) / (double)n;
                this.position = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
                this.time = (long)(this.duration * this.position);
                this.component.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.seekable) {
            mouseEvent.translatePoint(-1, -1);
            if (this.intersectButton1(mouseEvent)) {
                this.button1Color = Color.gray;
            } else {
                this.button1Color = Color.black;
                if (this.intersectButton2(mouseEvent)) {
                    this.button2Color = Color.gray;
                } else {
                    this.button2Color = Color.black;
                    this.seekColor = this.intersectSeeker(mouseEvent) ? Color.gray : Color.black;
                }
            }
            this.component.repaint();
        }
    }

    private final /* synthetic */ void this() {
        this.font = new Font("SansSerif", 0, 10);
        this.clicked = 0;
        this.state = 0;
        this.position = 0.0;
        this.speaker = "\u0000\u0000\u0000\u0000\u0000\u00ef\u0000\u0000\u00efU\u0017\u001e\u0000\u0000\u0000\u0000\u00ef\u00ef\u0000\u0000\u0000\u00efU\u0018\u0000\u0000\u0000\u00ef\u0000\u00ef\u0000\u00ef\u0000\u0000\u00ef\u0013\u00ef\u00ef\u00ef\u0000\u001c\u00ef\u0000Z\u00ef\u0000\u00ef\\\u00ef\u0000)+F\u00ef\u0000\u0000\u00ef\u0000\u00efr\u00efIbz\u0091\u00ef\u0000\u0000\u00ef\u0000\u00efr\u00ef\u00ef\u00ef\u00be\u00d3\u00ef\u0000Z\u00ef\u0000\u00ef\\\u0000\u0000\u0000\u00ef\u00ef\u00ef\u0000\u00ef\u0000\u0000\u00ef\u0000\u0000\u0000\u0000\u0000\u00ef\u00ef\u0000\u0000\u0000\u00ef\\\u0000\u0000\u0000\u0000\u0000\u0000\u00ef\u0000\u0000\u00ef\\\u0000\u0000";
        this.listeners = new Vector();
    }

    public Status(Component component) {
        this.this();
        int[] nArray = new int[120];
        this.component = component;
        int n = 0;
        while (n < 120) {
            nArray[n] = 0xFF000000 | this.speaker.charAt(n) << 16 | this.speaker.charAt(n) << 8 | this.speaker.charAt(n);
            ++n;
        }
        this.speakerImg = component.getToolkit().createImage(new MemoryImageSource(12, 10, nArray, 0, 12));
        this.button1Color = Color.black;
        this.button2Color = Color.black;
        this.seekColor = Color.black;
    }
}

