/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.jst.BusHandler;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.player.AboutFrame;
import com.fluendo.player.Configure;
import com.fluendo.player.CortadoPipeline;
import com.fluendo.player.Status;
import com.fluendo.player.StatusListener;
import com.fluendo.utils.Debug;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Cortado
extends Applet
implements Runnable,
MouseMotionListener,
MouseListener,
BusHandler,
StatusListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static Cortado cortado;
    private static CortadoPipeline pipeline;
    private static final String[] showStatusVals;
    private static final int STATUS_AUTO = 0;
    private static final int STATUS_SHOW = 1;
    private static final int STATUS_HIDE = 2;
    private String urlString;
    private boolean seekable;
    private boolean audio;
    private boolean video;
    private boolean keepAspect;
    private boolean autoPlay;
    private int bufferSize;
    private String userId;
    private String password;
    private int bufferLow;
    private int bufferHigh;
    private int debug;
    private double duration;
    private boolean statusRunning;
    private Thread statusThread;
    private Status status;
    private int statusHeight;
    private boolean inStatus;
    private boolean isBuffering;
    private int desiredState;
    private boolean isEOS;
    private boolean isError;
    private int showStatus;
    private int hideTimeout;
    private int hideCounter;
    private boolean mayHide;
    private PopupMenu menu;
    private Hashtable params;
    private Configure configure;
    private Dimension appletDimension;

    public String getAppletInfo() {
        return "Title: Fluendo media player \nAuthor: Wim Taymans \nA Java based network multimedia player.";
    }

    public String getRevision() {
        return "$Revision: 4053 $";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"url", "URL", "The media file to play"}, {"seekable", "boolean", "Can you seek in this file (default false)"}, {"duration", "float", "Total duration of the file in seconds (default unknown)"}, {"audio", "boolean", "Enable audio playback (default true)"}, {"video", "boolean", "Enable video playback (default true)"}, {"statusHeight", "int", "The height of the status area (default 12)"}, {"autoPlay", "boolean", "Automatically start playback (default true)"}, {"showStatus", "enum", "Show status area (auto|show|hide) (default auto)"}, {"hideTimeout", "int", "Timeout in seconds to hide the status area when showStatus is auto (default 0)"}, {"keepAspect", "boolean", "Use aspect ratio of video (default true)"}, {"bufferSize", "int", "The size of the prebuffer in Kbytes (default 100)"}, {"bufferLow", "int", "Percent of empty buffer (default 10)"}, {"bufferHigh", "int", "Percent of full buffer (default 70)"}, {"userId", "string", "userId for basic authentication (default null)"}, {"password", "string", "password for basic authentication (default null)"}, {"debug", "int", "Debug level 0 - 4 (default = 3)"}};
        return stringArray;
    }

    public void setParam(String string, String string2) {
        this.params.put(string, string2);
    }

    public void restart() {
        this.stop();
        this.init();
        this.start();
    }

    public String getParam(String string, String string2) {
        String string3 = (String)this.params.get(string);
        if (string3 == null) {
            try {
                string3 = this.getParameter(string);
            }
            catch (Exception exception) {}
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public int getEnum(String string, String[] stringArray, String string2) {
        String string3 = this.getParam(string, string2);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string3)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static void shutDown(Throwable throwable) {
        Debug.log(3, "shutting down: reason: " + throwable.getMessage());
        throwable.printStackTrace();
        cortado.stop();
    }

    public synchronized void init() {
        URL uRL;
        cortado = this;
        System.out.println("init()");
        if (pipeline != null) {
            this.stop();
        }
        pipeline = new CortadoPipeline();
        this.configure = new Configure();
        this.urlString = this.getParam("url", null);
        this.seekable = String.valueOf(this.getParam("seekable", "false")).equals("true");
        this.duration = Double.valueOf(this.getParam("duration", "-1.0"));
        this.audio = String.valueOf(this.getParam("audio", "true")).equals("true");
        this.video = String.valueOf(this.getParam("video", "true")).equals("true");
        this.statusHeight = Integer.valueOf(this.getParam("statusHeight", "12"));
        this.autoPlay = String.valueOf(this.getParam("autoPlay", "true")).equals("true");
        this.showStatus = this.getEnum("showStatus", showStatusVals, "auto");
        this.hideTimeout = Integer.valueOf(this.getParam("hideTimeout", "0"));
        this.keepAspect = String.valueOf(this.getParam("keepAspect", "true")).equals("true");
        this.bufferSize = Integer.valueOf(this.getParam("bufferSize", "200"));
        this.bufferLow = Integer.valueOf(this.getParam("bufferLow", "10"));
        this.bufferHigh = Integer.valueOf(this.getParam("bufferHigh", "70"));
        this.debug = Integer.valueOf(this.getParam("debug", "3"));
        this.userId = this.getParam("userId", null);
        this.password = this.getParam("password", null);
        if (System.getProperty("java.vendor").toUpperCase().startsWith("MICROSOFT", 0)) {
            this.seekable = false;
        }
        Debug.level = this.debug;
        Debug.log(3, "build info: " + this.configure.buildInfo);
        Debug.log(3, "revision: " + this.getRevision());
        pipeline.setUrl(this.urlString);
        pipeline.setUserId(this.userId);
        pipeline.setPassword(this.password);
        pipeline.enableAudio(this.audio);
        pipeline.enableVideo(this.video);
        pipeline.setBufferSize(this.bufferSize);
        pipeline.setBufferLow(this.bufferLow);
        pipeline.setBufferHigh(this.bufferHigh);
        try {
            uRL = this.getDocumentBase();
            Debug.log(3, "Document base: " + uRL);
        }
        catch (Throwable throwable) {
            uRL = null;
        }
        pipeline.setDocumentBase(uRL);
        pipeline.setComponent(this);
        pipeline.getBus().addHandler(this);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.status = new Status(this);
        this.status.setHaveAudio(this.audio);
        this.status.setHavePercent(true);
        this.status.setSeekable(this.seekable);
        this.status.setDuration(this.duration);
        this.inStatus = false;
        boolean bl = false;
        if (this.hideTimeout == 0) {
            bl = true;
        }
        this.mayHide = bl;
        this.hideCounter = 0;
        if (this.showStatus != 2) {
            this.status.setVisible(true);
        } else {
            this.status.setVisible(false);
        }
        this.menu = new PopupMenu();
        this.menu.add("About...");
        this.menu.addActionListener(this);
        this.add(this.menu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("About...")) {
            AboutFrame aboutFrame = new AboutFrame(pipeline);
            aboutFrame.d.setVisible(true);
        }
    }

    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        if (this.status != null && this.status.isVisible()) {
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height - this.statusHeight);
        } else {
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
        }
        return graphics;
    }

    public Dimension getSize() {
        if (this.appletDimension == null) {
            this.appletDimension = super.getSize();
        }
        return this.appletDimension;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void run() {
        try {
            this.realRun();
        }
        catch (Throwable throwable) {
            Cortado.shutDown(throwable);
        }
    }

    private final void realRun() {
        Debug.log(3, "entering status thread");
        while (this.statusRunning) {
            try {
                long l = pipeline.getPosition() / 1000000L;
                this.status.setTime(l);
                Thread.sleep(1000L);
                if (this.hideCounter <= 0) continue;
                --this.hideCounter;
                if (this.hideCounter != 0) continue;
                this.mayHide = true;
                this.setStatusVisible(false, false);
            }
            catch (Exception exception) {
                if (!this.statusRunning) continue;
                exception.printStackTrace();
            }
        }
        Debug.log(3, "exit status thread");
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (n <= 0 || n2 <= this.statusHeight) {
            this.appletDimension = null;
            return;
        }
        if (this.status != null && this.status.isVisible()) {
            this.status.setBounds(0, n2 - this.statusHeight, n, this.statusHeight);
            this.status.paint(graphics);
        }
    }

    private final void setStatusVisible(boolean bl, boolean bl2) {
        if (this.status.isVisible() == bl) {
            return;
        }
        if (!bl && !this.mayHide) {
            return;
        }
        if (!bl2) {
            if (this.showStatus == 1 && !bl) {
                return;
            }
            if (this.showStatus == 2 && bl) {
                return;
            }
        }
        if (this.isError && !bl) {
            return;
        }
        if (this.inStatus && !bl) {
            return;
        }
        this.status.setVisible(bl);
        this.repaint();
    }

    private final boolean intersectStatus(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getY() > this.getSize().height - this.statusHeight) {
            bl = true;
        }
        this.inStatus = bl;
        return this.inStatus;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setStatusVisible(false, false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.intersectStatus(mouseEvent)) {
            int n = this.getSize().height - this.statusHeight;
            mouseEvent.translatePoint(0, -n);
            this.status.mousePressed(mouseEvent);
        } else if ((mouseEvent.getModifiers() & 4) == 4) {
            this.menu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.intersectStatus(mouseEvent)) {
            int n = this.getSize().height - this.statusHeight;
            mouseEvent.translatePoint(0, -n);
            this.status.mouseReleased(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.intersectStatus(mouseEvent)) {
            int n = this.getSize().height - this.statusHeight;
            this.setStatusVisible(true, false);
            mouseEvent.translatePoint(0, -n);
            this.status.mouseDragged(mouseEvent);
        } else {
            this.setStatusVisible(false, false);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.intersectStatus(mouseEvent)) {
            int n = this.getSize().height - this.statusHeight;
            this.setStatusVisible(true, false);
            mouseEvent.translatePoint(0, -n);
            this.status.mouseMoved(mouseEvent);
        } else {
            this.setStatusVisible(false, false);
        }
    }

    public void handleMessage(Message message) {
        block0 : switch (message.getType()) {
            case 2: 
            case 4: {
                System.out.println(message.toString());
                if (this.isError) break;
                this.status.setMessage(message.parseErrorString());
                this.status.setState(0);
                pipeline.setState(1);
                this.setStatusVisible(true, true);
                this.isError = true;
                break;
            }
            case 1: {
                Debug.log(3, "EOS: playback ended");
                if (this.isError) break;
                this.status.setState(0);
                this.status.setMessage("Playback ended");
                this.isEOS = true;
                pipeline.setState(1);
                this.setStatusVisible(true, false);
                break;
            }
            case 8192: {
                System.out.println(message.toString());
                break;
            }
            case 524288: {
                if (this.isError) break;
                this.status.setMessage(message.parseResourceString());
                this.setStatusVisible(true, false);
                break;
            }
            case 32: {
                if (this.isError) break;
                boolean bl = message.parseBufferingBusy();
                int n = message.parseBufferingPercent();
                if (bl) {
                    if (!this.isBuffering) {
                        Debug.log(3, "PAUSE: we are buffering");
                        if (this.desiredState == 3) {
                            pipeline.setState(2);
                        }
                        this.isBuffering = true;
                        this.setStatusVisible(true, false);
                    }
                    this.status.setBufferPercent(bl, n);
                    break;
                }
                if (this.isBuffering) {
                    Debug.log(3, "PLAY: we finished buffering");
                    if (this.desiredState == 3) {
                        pipeline.setState(3);
                    }
                    this.isBuffering = false;
                    this.setStatusVisible(false, false);
                }
                this.status.setBufferPercent(bl, n);
                break;
            }
            case 64: {
                if (message.getSrc() != pipeline) break;
                int n = message.parseStateChangedOld();
                int n2 = message.parseStateChangedNext();
                switch (n2) {
                    case 2: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Paused");
                        }
                        this.status.setState(1);
                        break block0;
                    }
                    case 3: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Playing");
                            this.setStatusVisible(false, false);
                            if (!this.mayHide) {
                                this.hideCounter = this.hideTimeout;
                            }
                        }
                        this.status.setState(2);
                        break block0;
                    }
                    case 1: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Stopped");
                            this.setStatusVisible(true, false);
                        }
                        this.status.setState(0);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void doPause() {
        this.isError = false;
        this.isEOS = false;
        this.status.setMessage("Pause");
        this.desiredState = 2;
        pipeline.setState(this.desiredState);
    }

    public void doPlay() {
        this.isError = false;
        this.isEOS = false;
        this.status.setMessage("Play");
        this.desiredState = 3;
        pipeline.setState(this.desiredState);
    }

    public void doStop() {
        this.status.setMessage("Stop");
        this.desiredState = 1;
        pipeline.setState(this.desiredState);
    }

    public void doSeek(double d) {
        Event event = Event.newSeek(5, (int)(d * 100.0 * 10000.0));
        boolean bl = pipeline.sendEvent(event);
        if (!bl) {
            Debug.log(2, "seek failed");
        }
    }

    public void newState(int n) {
        switch (n) {
            case 1: {
                this.doPause();
                break;
            }
            case 2: {
                this.doPlay();
                break;
            }
            case 0: {
                this.doStop();
                break;
            }
        }
    }

    public void newSeek(double d) {
        this.doSeek(d);
    }

    public synchronized void start() {
        System.out.println("start()");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.status.addStatusListener(this);
        this.desiredState = this.autoPlay ? 3 : 2;
        int n = pipeline.setState(this.desiredState);
        if (this.statusThread != null) {
            throw new RuntimeException("invalid state");
        }
        this.statusThread = new Thread((Runnable)this, "cortado-StatusThread-" + Debug.genId());
        this.statusRunning = true;
        this.statusThread.start();
    }

    public synchronized void stop() {
        System.out.println("stop()");
        this.statusRunning = false;
        this.desiredState = 1;
        if (pipeline != null) {
            System.out.println("pipeline stop");
            pipeline.setState(this.desiredState);
            System.out.println("pipeline shutdown");
            pipeline.shutDown();
            System.out.println("pipeline stopped");
            pipeline = null;
        }
        if (this.statusThread != null) {
            try {
                this.statusThread.interrupt();
            }
            catch (Exception exception) {}
            try {
                this.statusThread.join();
            }
            catch (Exception exception) {}
            this.statusThread = null;
        }
    }

    private final /* synthetic */ void this() {
        this.statusHeight = 20;
        this.params = new Hashtable();
    }

    public Cortado() {
        this.this();
    }

    static {
        showStatusVals = new String[]{"auto", "show", "hide"};
    }
}

