/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Bus;
import com.fluendo.jst.BusSyncHandler;
import com.fluendo.jst.Clock;
import com.fluendo.jst.ClockProvider;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Object;
import com.fluendo.jst.Pad;
import com.fluendo.jst.Query;
import com.fluendo.jst.SystemClock;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Pipeline
extends Element
implements BusSyncHandler {
    protected Vector elements;
    protected Clock defClock;
    protected Clock fixedClock;
    protected Element clockProvider;
    protected Vector messages;
    protected Bus internalBus;
    private BusThread busThread;
    private StateThread stateThread;
    private boolean stateDirty;
    private boolean polling;
    protected long streamTime;

    public String getFactoryName() {
        return "pipeline";
    }

    public synchronized void shutDown() {
        if (this.stateThread != null) {
            this.stateThread.shutDown();
            this.stateThread = null;
        }
        if (this.busThread != null) {
            this.busThread.shutDown();
            this.busThread = null;
        }
    }

    public void useClock(Clock clock) {
        this.fixedClock = clock;
    }

    public boolean add(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ClockProvider) {
            this.defClock = ((ClockProvider)((java.lang.Object)element)).provideClock();
            this.clockProvider = element;
        }
        this.elements.addElement(element);
        element.baseTime = this.baseTime;
        element.setBus(this.internalBus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Element element) {
        if (element == null) {
            return false;
        }
        boolean bl = this.elements.removeElement(element);
        if (!bl) return bl;
        if (element == this.clockProvider) {
            this.defClock = new SystemClock();
            this.clockProvider = null;
        }
        element.setBus(null);
        element.setClock(null);
        Pipeline pipeline = this;
        synchronized (pipeline) {
            this.stateDirty = true;
            return bl;
        }
    }

    public Enumeration enumElements() {
        return this.elements.elements();
    }

    public Enumeration enumSorted() {
        return new SortedEnumerator();
    }

    public Enumeration enumSinks() {
        return new SinkEnumerator();
    }

    private final void replaceMessage(Message message, int n) {
        int n2 = this.messages.size();
        Object object = message.getSrc();
        int n3 = 0;
        while (n3 < n2) {
            Message message2 = (Message)this.messages.elementAt(n3);
            if (message2.getType() == n && message2.getSrc() == object) {
                this.messages.setElementAt(message, n3);
                return;
            }
            ++n3;
        }
        this.messages.addElement(message);
    }

    private final boolean findMessage(Object object, int n) {
        int n2 = this.messages.size();
        int n3 = 0;
        while (n3 < n2) {
            Message message = (Message)this.messages.elementAt(n3);
            if (message.getType() == n && message.getSrc() == object) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected boolean isEOS() {
        Enumeration enumeration = this.enumSinks();
        while (enumeration.hasMoreElements()) {
            Object object = (Object)enumeration.nextElement();
            if (this.findMessage(object, 1)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int handleSyncMessage(Message message) {
        switch (message.getType()) {
            case 1: {
                Pipeline pipeline = this;
                synchronized (pipeline) {
                    Debug.log(3, this + " got EOS from sink: " + message.getSrc());
                    this.replaceMessage(message, 1);
                    boolean bl = this.isEOS();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
                    if (!bl) return 0;
                }
                Debug.log(3, "all sinks posted EOS " + this);
                this.postMessage(Message.newEOS(this));
                return 0;
            }
            case 128: {
                this.scheduleReCalcState();
                return 0;
            }
        }
        this.postMessage(message);
        return 0;
    }

    public int getState(int[] nArray, int[] nArray2, long l) {
        this.reCalcState(false);
        return super.getState(nArray, nArray2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scheduleReCalcState() {
        Pipeline pipeline = this;
        synchronized (pipeline) {
            this.stateDirty = true;
            this.stateThread.stateDirty();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void reCalcState(boolean bl) {
        boolean bl2;
        boolean bl3;
        int n = 1;
        Pipeline pipeline = this;
        synchronized (pipeline) {
            if (bl) {
                this.stateDirty = true;
            }
            if (!this.stateDirty) {
                return;
            }
            if (this.polling) {
                return;
            }
            this.polling = true;
            this.stateDirty = false;
            bl3 = false;
            bl2 = false;
        }
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            n = element.getState(null, null, 1L);
            switch (n) {
                case 2: {
                    bl3 = true;
                    break;
                }
                case 3: {
                    bl2 = true;
                    break;
                }
            }
            if (n == 0) break;
        }
        if (n != 0) {
            if (bl2) {
                n = 3;
            }
            if (bl3) {
                n = 2;
            }
        }
        pipeline = this;
        synchronized (pipeline) {
            this.polling = false;
        }
        switch (n) {
            case 1: 
            case 3: {
                n = this.continueState(n);
                return;
            }
            case 2: {
                this.lostState();
                return;
            }
            case 0: {
                this.abortState();
                return;
            }
        }
    }

    protected int doChildStateChange(int n) {
        int n2;
        int n3 = this.getTransitionNext(n);
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = this.enumSorted();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            element.setBus(this.internalBus);
            element.setClock(this.defClock);
            element.baseTime = this.baseTime;
            Debug.log(4, this + " setting state " + n3 + " on " + element);
            n2 = element.setState(n3);
            Debug.log(4, this + ' ' + element + " changed state " + n2);
            switch (n2) {
                case 2: {
                    bl = true;
                    break;
                }
                case 3: {
                    bl2 = true;
                    break;
                }
                case 0: {
                    return n2;
                }
            }
        }
        n2 = super.changeState(n);
        if (n2 == 0) {
            return n2;
        }
        if (bl2) {
            n2 = 3;
        } else if (bl) {
            n2 = 2;
        }
        return n2;
    }

    protected int changeState(int n) {
        long l;
        switch (n) {
            case 18: {
                this.messages.setSize(0);
                break;
            }
            case 35: {
                l = this.defClock.getTime();
                this.baseTime = l - this.streamTime;
                break;
            }
        }
        int n2 = this.doChildStateChange(n);
        switch (n) {
            case 18: {
                this.streamTime = 0L;
                break;
            }
            case 50: {
                l = this.defClock.getTime();
                this.streamTime = l - this.baseTime;
                this.messages.setSize(0);
                break;
            }
            case 33: {
                this.messages.setSize(0);
                break;
            }
        }
        return n2;
    }

    protected boolean doSendEvent(Event event) {
        boolean bl = true;
        Enumeration enumeration = this.enumSinks();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            bl &= element.sendEvent(event);
        }
        return bl;
    }

    private final boolean doSeek(Event event) {
        boolean bl;
        boolean bl2;
        int[] nArray = new int[1];
        this.getState(nArray, null, 0L);
        boolean bl3 = false;
        if (nArray[0] == 3) {
            bl3 = true;
        }
        if (bl2 = bl3) {
            this.setState(2);
        }
        if (bl = this.doSendEvent(event)) {
            this.streamTime = 0L;
        }
        if (bl2) {
            this.setState(3);
        }
        return bl;
    }

    public boolean sendEvent(Event event) {
        switch (event.getType()) {
            case 5: {
                return this.doSeek(event);
            }
        }
        return this.doSendEvent(event);
    }

    public boolean query(Query query) {
        boolean bl = true;
        Enumeration enumeration = this.enumSinks();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            bl = element.query(query);
            if (bl) break;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.elements = new Vector();
        this.fixedClock = null;
        this.messages = new Vector();
        this.stateDirty = false;
        this.polling = false;
    }

    public Pipeline() {
        this(null);
    }

    public Pipeline(String string) {
        super(string);
        this.this();
        this.defClock = new SystemClock();
        this.clockProvider = null;
        this.internalBus = new Bus();
        this.internalBus.setSyncHandler(this);
        this.bus = new Bus();
        this.busThread = new BusThread(this.bus);
        this.busThread.start();
        this.stateThread = new StateThread();
        this.stateThread.start();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class StateThread
    extends Thread {
        private boolean stopping = false;
        private boolean stateDirty = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (!this.stopping) {
                StateThread stateThread = this;
                // MONITORENTER : stateThread
                {
                    while (!this.stateDirty && !this.stopping) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.stateDirty = false;
                    // MONITOREXIT : stateThread
                    if (this.stopping) continue;
                }
                java.lang.Object object = Pipeline.this.stateLock;
                // MONITORENTER : object
                Pipeline.this.reCalcState(false);
                // MONITOREXIT : object
            }
        }

        public synchronized void stateDirty() {
            this.stateDirty = true;
            this.notifyAll();
        }

        public synchronized void shutDown() {
            this.stopping = true;
            this.notifyAll();
        }

        public StateThread() {
            super("cortado-StateThread-" + Debug.genId());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BusThread
    extends Thread {
        private Bus bus;
        private boolean stopping;

        public void run() {
            while (!this.stopping) {
                this.bus.waitAndDispatch();
            }
        }

        public void shutDown() {
            this.stopping = true;
            this.bus.setFlushing(true);
        }

        public BusThread(Bus bus) {
            super("cortado-BusThread-" + Debug.genId());
            this.bus = bus;
            this.stopping = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SortedEnumerator
    implements Enumeration {
        private Vector queue = new Vector();
        private Hashtable hash = new Hashtable();
        private java.lang.Object next;
        private int mode;

        private final void addToQueue(Element element) {
            this.queue.addElement(element);
            this.hash.put(element, new Integer(-1));
        }

        private final void updateDegree(Element element) {
            Enumeration enumeration = element.enumPads();
            while (enumeration.hasMoreElements()) {
                Element element2;
                Pad pad;
                Pad pad2 = (Pad)enumeration.nextElement();
                if (pad2.direction != 2 || (pad = pad2.peer) == null || (element2 = (Element)pad.parent) == null) continue;
                int n = (Integer)this.hash.get(element2);
                int n2 = n + this.mode;
                if (n2 == 0) {
                    this.addToQueue(element2);
                    continue;
                }
                this.hash.put(element2, new Integer(n2));
            }
        }

        private final void queueNextElement() {
            if (this.queue.isEmpty()) {
                int n = Integer.MAX_VALUE;
                Element element = null;
                Enumeration enumeration = Pipeline.this.enumElements();
                while (enumeration.hasMoreElements()) {
                    Element element2 = (Element)enumeration.nextElement();
                    int n2 = (Integer)this.hash.get(element2);
                    if (n2 < 0 || element != null && n <= n2) continue;
                    element = element2;
                    n = n2;
                }
                if (element != null) {
                    if (n != 0) {
                        System.out.println(this + " loop detected in pipeline!!");
                    }
                    this.next = element;
                    this.hash.put(this.next, new Integer(-1));
                } else {
                    this.next = null;
                }
            } else {
                this.next = this.queue.elementAt(0);
                this.queue.removeElementAt(0);
            }
            if (this.next != null) {
                this.updateDegree((Element)this.next);
            }
        }

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.next != null) {
                bl = true;
            }
            return bl;
        }

        public java.lang.Object nextElement() throws NoSuchElementException {
            java.lang.Object object = this.next;
            if (object == null) {
                throw new NoSuchElementException();
            }
            this.queueNextElement();
            return object;
        }

        public SortedEnumerator() {
            Enumeration enumeration = Pipeline.this.enumElements();
            while (enumeration.hasMoreElements()) {
                Element element = (Element)enumeration.nextElement();
                if (element.isFlagSet(32)) {
                    this.addToQueue(element);
                    continue;
                }
                this.hash.put(element, new Integer(0));
            }
            this.mode = 1;
            enumeration = Pipeline.this.enumElements();
            while (enumeration.hasMoreElements()) {
                this.updateDegree((Element)enumeration.nextElement());
            }
            this.mode = -1;
            this.queueNextElement();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SinkEnumerator
    implements Enumeration {
        private Enumeration e;
        private java.lang.Object next;

        private final void queueNextElement() {
            this.next = null;
            while (this.e.hasMoreElements()) {
                Element element = (Element)this.e.nextElement();
                if (!element.isFlagSet(32)) continue;
                this.next = element;
                break;
            }
        }

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.next != null) {
                bl = true;
            }
            return bl;
        }

        public java.lang.Object nextElement() throws NoSuchElementException {
            java.lang.Object object = this.next;
            if (object == null) {
                throw new NoSuchElementException();
            }
            this.queueNextElement();
            return object;
        }

        public SinkEnumerator() {
            this.e = Pipeline.this.enumElements();
            this.queueNextElement();
        }
    }
}

