/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Object;
import com.fluendo.jst.Pad;

public class Message {
    public static final int EOS = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 4;
    public static final int INFO = 8;
    public static final int TAG = 16;
    public static final int BUFFERING = 32;
    public static final int STATE_CHANGED = 64;
    public static final int STATE_DIRTY = 128;
    public static final int STEP_DONE = 256;
    public static final int CLOCK_PROVIDE = 512;
    public static final int CLOCK_LOST = 1024;
    public static final int NEW_CLOCK = 2048;
    public static final int STRUCTURE_CHANGE = 4096;
    public static final int STREAM_STATUS = 8192;
    public static final int APPLICATION = 16384;
    public static final int ELEMENT = 32768;
    public static final int SEGMENT_START = 65536;
    public static final int SEGMENT_DONE = 131072;
    public static final int DURATION = 262144;
    public static final int RESOURCE = 524288;
    private Object src;
    private int type;
    private boolean bool;
    private int value;
    private String string;
    private int old;
    private int next;
    private int pending;

    public Object getSrc() {
        return this.src;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "[Message]: " + this.src + " type: EOS";
            }
            case 32: {
                return "[Message]: " + this.src + " type: BUFFERING, busy:" + this.bool + ", percent:" + this.value;
            }
            case 64: {
                return "[Message]: " + this.src + " type: STATE_CHANGED, old:" + this.old + ", next:" + this.next + ", pending:" + this.pending;
            }
            case 128: {
                return "[Message]: " + this.src + " type: STATE_DIRTY";
            }
            case 8192: {
                return "[Message]: " + this.src + " type: STREAM_STATUS, " + (this.bool ? "start" : "stop") + ", reason: " + Pad.getFlowName(this.value) + ", " + this.string;
            }
            case 2: {
                return "[Message]: " + this.src + " type: ERROR, " + this.string;
            }
        }
        return "[Message]: " + this.src + " type: " + this.type;
    }

    public static Message newEOS(Object object) {
        return new Message(object, 1);
    }

    public static Message newError(Object object, String string) {
        Message message = new Message(object, 2);
        message.string = string;
        return message;
    }

    public static Message newWarning(Object object, String string) {
        Message message = new Message(object, 4);
        message.string = string;
        return message;
    }

    public String parseErrorString() {
        return this.string;
    }

    public static Message newBuffering(Object object, boolean bl, int n) {
        Message message = new Message(object, 32);
        message.bool = bl;
        message.value = n;
        return message;
    }

    public boolean parseBufferingBusy() {
        return this.bool;
    }

    public int parseBufferingPercent() {
        return this.value;
    }

    public static Message newStateChanged(Object object, int n, int n2, int n3) {
        Message message = new Message(object, 64);
        message.old = n;
        message.next = n2;
        message.pending = n3;
        return message;
    }

    public int parseStateChangedOld() {
        return this.old;
    }

    public int parseStateChangedNext() {
        return this.next;
    }

    public int parseStateChangedPending() {
        return this.pending;
    }

    public static Message newStateDirty(Object object) {
        return new Message(object, 128);
    }

    public static Message newStreamStatus(Object object, boolean bl, int n, String string) {
        Message message = new Message(object, 8192);
        message.string = string;
        message.bool = bl;
        message.value = n;
        return message;
    }

    public String parseStreamStatusString() {
        return this.string;
    }

    public boolean parseStreamStatusStart() {
        return this.bool;
    }

    public int parseStreamStatusReason() {
        return this.value;
    }

    public static Message newResource(Object object, String string) {
        Message message = new Message(object, 524288);
        message.string = string;
        return message;
    }

    public String parseResourceString() {
        return this.string;
    }

    private Message(Object object, int n) {
        this.src = object;
        this.type = n;
    }
}

