/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

public abstract class Clock {
    public static final long USECOND = 1L;
    public static final long MSECOND = 1000L;
    public static final long SECOND = 1000000L;
    public static final int SINGLE = 0;
    public static final int PERIODIC = 0;
    public static final int OK = 0;
    public static final int EARLY = 1;
    public static final int UNSCHEDULED = 2;
    public static final int BUSY = 3;
    public static final int BADTIME = 4;
    public static final int ERROR = 5;
    public static final int UNSUPPORTED = 6;
    private long adjust = 0L;
    private long lastTime = 0L;

    protected synchronized long adjust(long l) {
        long l2 = l + this.adjust;
        if (l2 < this.lastTime) {
            l2 = this.lastTime;
        } else {
            this.lastTime = l2;
        }
        return l2;
    }

    protected abstract long getInternalTime();

    protected abstract int waitFunc(ClockID var1);

    protected abstract int waitAsyncFunc(ClockID var1);

    protected abstract void unscheduleFunc(ClockID var1);

    public synchronized long getTime() {
        long l = this.getInternalTime();
        long l2 = this.adjust(l);
        return l2;
    }

    public synchronized void setAdjust(long l) {
        this.adjust = l;
    }

    public synchronized long getAdjust() {
        return this.adjust;
    }

    public ClockID newSingleShotID(long l) {
        return new ClockID(l, 0L, 0);
    }

    public ClockID newPeriodicID(long l, long l2) {
        return new ClockID(l, l2, 0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ClockID {
        long time;
        long interval;
        int type;
        int status;

        public long getTime() {
            return this.time;
        }

        public int waitID() {
            int n = Clock.this.waitFunc(this);
            if (this.type == 0) {
                this.time += this.interval;
            }
            return n;
        }

        public void unschedule() {
            Clock.this.unscheduleFunc(this);
        }

        public ClockID(long l, long l2, int n) {
            this.time = l;
            this.interval = l2;
            this.type = n;
        }
    }
}

