/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.BusHandler;
import com.fluendo.jst.BusSyncHandler;
import com.fluendo.jst.Message;
import java.util.Enumeration;
import java.util.Vector;

public class Bus {
    private Vector queue = new Vector();
    private Vector handlers = new Vector();
    private boolean flushing = false;
    private BusSyncHandler syncHandler;

    public synchronized void addHandler(BusHandler busHandler) {
        this.handlers.addElement(busHandler);
    }

    public synchronized void removeHandler(BusHandler busHandler) {
        this.handlers.removeElement(busHandler);
    }

    public synchronized void setSyncHandler(BusSyncHandler busSyncHandler) {
        this.syncHandler = busSyncHandler;
    }

    private final void notifyHandlers(Vector vector, Message message) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            BusHandler busHandler = (BusHandler)enumeration.nextElement();
            busHandler.handleMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void post(Message message) {
        BusSyncHandler busSyncHandler;
        boolean bl = true;
        Bus bus = this;
        synchronized (bus) {
            if (this.flushing) {
                return;
            }
            busSyncHandler = this.syncHandler;
        }
        boolean bl2 = false;
        if (busSyncHandler == null || busSyncHandler.handleSyncMessage(message) == 1) {
            bl2 = true;
        }
        bl = bl2;
        bus = this;
        synchronized (bus) {
            if (bl && !this.flushing) {
                this.queue.addElement(message);
                this.notifyAll();
            }
            return;
        }
    }

    public synchronized Message peek() {
        if (this.queue.isEmpty() || this.flushing) {
            return null;
        }
        return (Message)this.queue.firstElement();
    }

    public synchronized Message pop() {
        if (this.queue.isEmpty() || this.flushing) {
            return null;
        }
        Message message = (Message)this.queue.elementAt(0);
        this.queue.removeElementAt(0);
        return message;
    }

    public synchronized Message poll(long l) {
        if (this.queue.isEmpty() && !this.flushing) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.pop();
    }

    public synchronized void setFlushing(boolean bl) {
        this.flushing = bl;
        this.queue.setSize(0);
        this.notifyAll();
    }

    public void waitAndDispatch() {
        Message message = this.poll(0L);
        if (message != null) {
            this.notifyHandlers(this.handlers, message);
        }
    }
}

