/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Caps;
import java.util.EmptyStackException;
import java.util.Stack;

public class Buffer {
    private static Stack pool = new Stack();
    private static int live;
    public static final int FLAG_DISCONT = 1;
    public static final int FLAG_DELTA_UNIT = 2;
    public int flags;
    public Object object;
    public byte[] data;
    public int offset;
    public int length;
    public Caps caps;
    public long time_offset;
    public long timestamp;
    public long timestampEnd;

    public static Buffer create() {
        Buffer buffer;
        try {
            buffer = (Buffer)pool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            buffer = new Buffer();
            ++live;
        }
        buffer.time_offset = -1;
        buffer.timestamp = -1;
        buffer.timestampEnd = -1;
        buffer.flags = 0;
        return buffer;
    }

    public boolean isFlagSet(int n) {
        boolean bl = false;
        if ((this.flags & n) == n) {
            bl = true;
        }
        return bl;
    }

    public void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public void free() {
        this.object = null;
        this.caps = null;
        pool.push(this);
    }

    public void ensureSize(int n) {
        if (this.data == null) {
            this.data = new byte[n];
        } else if (this.data.length < n) {
            this.data = new byte[n];
        }
    }

    public void copyData(byte[] byArray, int n, int n2) {
        this.ensureSize(n2);
        System.arraycopy(byArray, n, this.data, 0, n2);
        this.offset = 0;
        this.length = n2;
    }
}

