/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Decode;
import com.fluendo.jheora.FrInit;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.Playback;
import com.fluendo.jheora.YUVBuffer;
import com.jcraft.jogg.Packet;

public class State {
    long granulepos;
    private Playback pbi;
    private Decode dec;

    public void clear() {
        if (this.pbi != null) {
            this.pbi.info.clear();
            this.pbi.clearHuffmanSet();
            FrInit.ClearFragmentInfo(this.pbi);
            FrInit.ClearFrameInfo(this.pbi);
            this.pbi.clear();
        }
        this.pbi = null;
    }

    public int decodeInit(Info info) {
        this.pbi = new Playback(info);
        this.dec = new Decode(this.pbi);
        this.granulepos = -1;
        return 0;
    }

    public boolean isKeyframe(Packet packet) {
        boolean bl = false;
        if ((packet.packet_base[packet.packet] & 0x40) == 0) {
            bl = true;
        }
        return bl;
    }

    public int decodePacketin(Packet packet) {
        this.pbi.DecoderErrorCode = 0;
        this.pbi.opb.readinit(packet.packet_base, packet.packet, packet.bytes);
        long l = this.pbi.opb.readB(1);
        if (l == 0L) {
            l = this.dec.loadAndDecode();
            if (l != 0L) {
                return (int)l;
            }
            if (packet.granulepos > (long)-1) {
                this.granulepos = packet.granulepos;
            } else if (this.granulepos == (long)-1) {
                this.granulepos = 0L;
            } else if (this.pbi.FrameType == 0) {
                long l2 = this.granulepos & (long)((1 << this.pbi.keyframe_granule_shift) - 1);
                this.granulepos >>= this.pbi.keyframe_granule_shift;
                this.granulepos += l2 + 1L;
                this.granulepos <<= this.pbi.keyframe_granule_shift;
            } else {
                ++this.granulepos;
            }
            return 0;
        }
        return -24;
    }

    public int decodeYUVout(YUVBuffer yUVBuffer) {
        yUVBuffer.y_width = this.pbi.info.width;
        yUVBuffer.y_height = this.pbi.info.height;
        yUVBuffer.y_stride = this.pbi.YStride;
        yUVBuffer.uv_width = this.pbi.info.width / 2;
        yUVBuffer.uv_height = this.pbi.info.height / 2;
        yUVBuffer.uv_stride = this.pbi.UVStride;
        yUVBuffer.data = this.pbi.PostProcessingLevel != 0 ? this.pbi.PostProcessBuffer : this.pbi.LastFrameRecon;
        yUVBuffer.y_offset = this.pbi.ReconYDataOffset;
        yUVBuffer.u_offset = this.pbi.ReconUDataOffset;
        yUVBuffer.v_offset = this.pbi.ReconVDataOffset;
        yUVBuffer.y_offset += yUVBuffer.y_stride * (yUVBuffer.y_height - 1);
        yUVBuffer.u_offset += yUVBuffer.uv_stride * (yUVBuffer.uv_height - 1);
        yUVBuffer.v_offset += yUVBuffer.uv_stride * (yUVBuffer.uv_height - 1);
        yUVBuffer.y_stride = -yUVBuffer.y_stride;
        yUVBuffer.uv_stride = -yUVBuffer.uv_stride;
        yUVBuffer.newPixels();
        return 0;
    }

    public double granuleTime(long l) {
        if (l >= 0L) {
            long l2 = l >> this.pbi.keyframe_granule_shift;
            long l3 = l - (l2 << this.pbi.keyframe_granule_shift);
            return (double)(l2 + l3) * ((double)this.pbi.info.fps_denominator / (double)this.pbi.info.fps_numerator);
        }
        return -1.0;
    }
}

