/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.FuncMapping;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.FuncTime;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMapping0;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.LookMapping0;
import com.jcraft.jorbis.Mdct;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Mapping0
extends FuncMapping {
    static int seq = 0;
    float[][] pcmbundle;
    int[] zerobundle;
    int[] nonzero;
    Object[] floormemo;

    void free_info(Object object) {
    }

    void free_look(Object object) {
    }

    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        LookMapping0 lookMapping0 = new LookMapping0();
        InfoMapping0 infoMapping0 = lookMapping0.map = (InfoMapping0)object;
        lookMapping0.mode = infoMode;
        lookMapping0.time_look = new Object[infoMapping0.submaps];
        lookMapping0.floor_look = new Object[infoMapping0.submaps];
        lookMapping0.residue_look = new Object[infoMapping0.submaps];
        lookMapping0.time_func = new FuncTime[infoMapping0.submaps];
        lookMapping0.floor_func = new FuncFloor[infoMapping0.submaps];
        lookMapping0.residue_func = new FuncResidue[infoMapping0.submaps];
        int n = 0;
        while (n < infoMapping0.submaps) {
            int n2 = infoMapping0.timesubmap[n];
            int n3 = infoMapping0.floorsubmap[n];
            int n4 = infoMapping0.residuesubmap[n];
            lookMapping0.time_func[n] = FuncTime.time_P[info.time_type[n2]];
            lookMapping0.time_look[n] = lookMapping0.time_func[n].look(dspState, infoMode, info.time_param[n2]);
            lookMapping0.floor_func[n] = FuncFloor.floor_P[info.floor_type[n3]];
            lookMapping0.floor_look[n] = lookMapping0.floor_func[n].look(dspState, infoMode, info.floor_param[n3]);
            lookMapping0.residue_func[n] = FuncResidue.residue_P[info.residue_type[n4]];
            lookMapping0.residue_look[n] = lookMapping0.residue_func[n].look(dspState, infoMode, info.residue_param[n4]);
            ++n;
        }
        if (info.psys != 0) {
            int cfr_ignored_0 = dspState.analysisp;
        }
        lookMapping0.ch = info.channels;
        return lookMapping0;
    }

    void pack(Info info, Object object, Buffer buffer) {
        int n;
        InfoMapping0 infoMapping0 = (InfoMapping0)object;
        if (infoMapping0.submaps > 1) {
            buffer.write(1, 1);
            buffer.write(infoMapping0.submaps - 1, 4);
        } else {
            buffer.write(0, 1);
        }
        if (infoMapping0.coupling_steps > 0) {
            buffer.write(1, 1);
            buffer.write(infoMapping0.coupling_steps - 1, 8);
            n = 0;
            while (n < infoMapping0.coupling_steps) {
                buffer.write(infoMapping0.coupling_mag[n], Mapping0.ilog2(info.channels));
                buffer.write(infoMapping0.coupling_ang[n], Mapping0.ilog2(info.channels));
                ++n;
            }
        } else {
            buffer.write(0, 1);
        }
        buffer.write(0, 2);
        if (infoMapping0.submaps > 1) {
            n = 0;
            while (n < info.channels) {
                buffer.write(infoMapping0.chmuxlist[n], 4);
                ++n;
            }
        }
        n = 0;
        while (n < infoMapping0.submaps) {
            buffer.write(infoMapping0.timesubmap[n], 8);
            buffer.write(infoMapping0.floorsubmap[n], 8);
            buffer.write(infoMapping0.residuesubmap[n], 8);
            ++n;
        }
    }

    Object unpack(Info info, Buffer buffer) {
        int n;
        InfoMapping0 infoMapping0 = new InfoMapping0();
        infoMapping0.submaps = buffer.read(1) != 0 ? buffer.read(4) + 1 : 1;
        if (buffer.read(1) != 0) {
            infoMapping0.coupling_steps = buffer.read(8) + 1;
            n = 0;
            while (n < infoMapping0.coupling_steps) {
                int n2 = infoMapping0.coupling_mag[n] = buffer.read(Mapping0.ilog2(info.channels));
                int n3 = infoMapping0.coupling_ang[n] = buffer.read(Mapping0.ilog2(info.channels));
                if (n2 < 0 || n3 < 0 || n2 == n3 || n2 >= info.channels || n3 >= info.channels) {
                    infoMapping0.free();
                    return null;
                }
                ++n;
            }
        }
        if (buffer.read(2) > 0) {
            infoMapping0.free();
            return null;
        }
        if (infoMapping0.submaps > 1) {
            n = 0;
            while (n < info.channels) {
                infoMapping0.chmuxlist[n] = buffer.read(4);
                if (infoMapping0.chmuxlist[n] >= infoMapping0.submaps) {
                    infoMapping0.free();
                    return null;
                }
                ++n;
            }
        }
        n = 0;
        while (n < infoMapping0.submaps) {
            infoMapping0.timesubmap[n] = buffer.read(8);
            if (infoMapping0.timesubmap[n] >= info.times) {
                infoMapping0.free();
                return null;
            }
            infoMapping0.floorsubmap[n] = buffer.read(8);
            if (infoMapping0.floorsubmap[n] >= info.floors) {
                infoMapping0.free();
                return null;
            }
            infoMapping0.residuesubmap[n] = buffer.read(8);
            if (infoMapping0.residuesubmap[n] >= info.residues) {
                infoMapping0.free();
                return null;
            }
            ++n;
        }
        return infoMapping0;
    }

    synchronized int inverse(Block block, Object object) {
        int n;
        int n2;
        float[] fArray;
        DspState dspState = block.vd;
        Info info = dspState.vi;
        LookMapping0 lookMapping0 = (LookMapping0)object;
        InfoMapping0 infoMapping0 = lookMapping0.map;
        InfoMode infoMode = lookMapping0.mode;
        int n3 = block.pcmend = info.blocksizes[block.W];
        float[] fArray2 = dspState.window[block.W][block.lW][block.nW][infoMode.windowtype];
        if (this.pcmbundle == null || this.pcmbundle.length < info.channels) {
            this.pcmbundle = new float[info.channels][];
            this.nonzero = new int[info.channels];
            this.zerobundle = new int[info.channels];
            this.floormemo = new Object[info.channels];
        }
        int n4 = 0;
        while (n4 < info.channels) {
            fArray = block.pcm[n4];
            n2 = infoMapping0.chmuxlist[n4];
            this.floormemo[n4] = lookMapping0.floor_func[n2].inverse1(block, lookMapping0.floor_look[n2], this.floormemo[n4]);
            this.nonzero[n4] = this.floormemo[n4] != null ? 1 : 0;
            n = 0;
            while (n < n3 / 2) {
                fArray[n] = 0.0f;
                ++n;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < infoMapping0.coupling_steps) {
            if (this.nonzero[infoMapping0.coupling_mag[n4]] != 0 || this.nonzero[infoMapping0.coupling_ang[n4]] != 0) {
                this.nonzero[infoMapping0.coupling_mag[n4]] = 1;
                this.nonzero[infoMapping0.coupling_ang[n4]] = 1;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < infoMapping0.submaps) {
            int n5 = 0;
            n2 = 0;
            while (n2 < info.channels) {
                if (infoMapping0.chmuxlist[n2] == n4) {
                    this.zerobundle[n5] = this.nonzero[n2] != 0 ? 1 : 0;
                    this.pcmbundle[n5++] = block.pcm[n2];
                }
                ++n2;
            }
            lookMapping0.residue_func[n4].inverse(block, lookMapping0.residue_look[n4], this.pcmbundle, this.zerobundle, n5);
            ++n4;
        }
        n4 = infoMapping0.coupling_steps - 1;
        while (n4 >= 0) {
            fArray = block.pcm[infoMapping0.coupling_mag[n4]];
            float[] fArray3 = block.pcm[infoMapping0.coupling_ang[n4]];
            n = 0;
            while (n < n3 / 2) {
                float f = fArray[n];
                float f2 = fArray3[n];
                if (f > 0.0f) {
                    if (f2 > 0.0f) {
                        fArray[n] = f;
                        fArray3[n] = f - f2;
                    } else {
                        fArray3[n] = f;
                        fArray[n] = f + f2;
                    }
                } else if (f2 > 0.0f) {
                    fArray[n] = f;
                    fArray3[n] = f + f2;
                } else {
                    fArray3[n] = f;
                    fArray[n] = f - f2;
                }
                ++n;
            }
            --n4;
        }
        n4 = 0;
        while (n4 < info.channels) {
            fArray = block.pcm[n4];
            int n6 = infoMapping0.chmuxlist[n4];
            lookMapping0.floor_func[n6].inverse2(block, lookMapping0.floor_look[n6], this.floormemo[n4], fArray);
            ++n4;
        }
        n4 = 0;
        while (n4 < info.channels) {
            fArray = block.pcm[n4];
            ((Mdct)dspState.transform[block.W][0]).backward(fArray, fArray);
            ++n4;
        }
        n4 = 0;
        while (n4 < info.channels) {
            int n7;
            fArray = block.pcm[n4];
            if (this.nonzero[n4] != 0) {
                n7 = 0;
                while (n7 < n3) {
                    int n8 = n7;
                    fArray[n8] = fArray[n8] * fArray2[n7];
                    ++n7;
                }
            } else {
                n7 = 0;
                while (n7 < n3) {
                    fArray[n7] = 0.0f;
                    ++n7;
                }
            }
            ++n4;
        }
        return 0;
    }

    private static final int ilog2(int n) {
        int n2 = 0;
        while (n > 1) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    private final /* synthetic */ void this() {
        this.pcmbundle = null;
        this.zerobundle = null;
        this.nonzero = null;
        this.floormemo = null;
    }

    Mapping0() {
        this.this();
    }
}

