/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jheora.Comment;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.State;
import com.fluendo.jheora.YUVBuffer;
import com.fluendo.player.MediaBuffer;
import com.fluendo.player.Plugin;
import com.fluendo.utils.Debug;
import com.jcraft.jogg.Packet;
import java.awt.Component;
import java.awt.Toolkit;

public class TheoraPlugin
extends Plugin {
    private Component component;
    private Toolkit toolkit;
    private Info ti;
    private Comment tc;
    private State ts;
    private Packet op;
    private int packet;
    private YUVBuffer yuv;

    public String getMime() {
        return "video/x-theora";
    }

    public int typeFind(byte[] byArray, int n, int n2) {
        if (byArray[n + 1] == 116) {
            return 20;
        }
        return 0;
    }

    public void initDecoder(Component component) {
        this.component = component;
        this.toolkit = this.component.getToolkit();
        this.ti = new Info();
        this.tc = new Comment();
        this.ts = new State();
        this.yuv = new YUVBuffer();
        this.op = new Packet();
        this.packet = 0;
    }

    public long offsetToTime(long l) {
        return (long)(this.ts.granuleTime(l) * 1000.0);
    }

    public MediaBuffer decode(MediaBuffer mediaBuffer) {
        this.op.packet_base = mediaBuffer.data;
        this.op.packet = mediaBuffer.offset;
        this.op.bytes = mediaBuffer.length;
        int n = 0;
        if (this.packet == 0) {
            n = 1;
        }
        this.op.b_o_s = n;
        this.op.e_o_s = 0;
        this.op.packetno = this.packet;
        if (this.packet < 3) {
            if (this.ti.decodeHeader(this.tc, this.op) < 0) {
                mediaBuffer.free();
                Debug.log(1, "does not contain Theora video data.");
                return null;
            }
            if (this.packet == 2) {
                this.ts.decodeInit(this.ti);
                Debug.log(3, "theora dimension: " + this.ti.width + 'x' + this.ti.height);
                if (this.ti.aspect_denominator == 0) {
                    this.ti.aspect_numerator = 1;
                    this.ti.aspect_denominator = 1;
                }
                Debug.log(3, "theora offset: " + this.ti.offset_x + ',' + this.ti.offset_y);
                Debug.log(3, "theora frame: " + this.ti.frame_width + ',' + this.ti.frame_height);
                Debug.log(3, "theora aspect: " + this.ti.aspect_numerator + '/' + this.ti.aspect_denominator);
                Debug.log(3, "theora framerate: " + this.ti.fps_numerator + '/' + this.ti.fps_denominator);
                this.fps_numerator = this.ti.fps_numerator;
                this.fps_denominator = this.ti.fps_denominator;
                this.aspect_numerator = this.ti.aspect_numerator;
                this.aspect_denominator = this.ti.aspect_denominator;
            }
            mediaBuffer.free();
            mediaBuffer = null;
        } else {
            if (this.ts.decodePacketin(this.op) != 0) {
                mediaBuffer.free();
                Debug.log(1, "Error Decoding Theora.");
                return null;
            }
            if (this.ts.decodeYUVout(this.yuv) != 0) {
                mediaBuffer.free();
                Debug.log(1, "Error getting the picture.");
                return null;
            }
            mediaBuffer.object = this.yuv.getObject(this.ti.offset_x, this.ti.offset_y, this.ti.frame_width, this.ti.frame_height);
        }
        ++this.packet;
        return mediaBuffer;
    }

    public void stop() {
    }

    public TheoraPlugin() {
        super(2);
    }
}

