/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.Clock;
import com.fluendo.player.Cortado;
import com.fluendo.player.DataConsumer;
import com.fluendo.player.ImageTarget;
import com.fluendo.player.MediaBuffer;
import com.fluendo.player.Plugin;
import com.fluendo.player.QueueManager;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VideoConsumer
implements DataConsumer,
Runnable {
    private static final int MAX_BUFFER = 100;
    private ImageTarget target;
    private Component component;
    private int queueid;
    private long framenr;
    private Clock clock;
    private boolean ready;
    private double framerate;
    private double frameperiod;
    private double aspect;
    private boolean stopping;
    private Plugin plugin;
    private long queuedTime;
    private Vector preQueue;
    private boolean preQueueing;
    private long framesQueued;

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void consume(MediaBuffer mediaBuffer) {
        block2: {
            try {
                QueueManager.enqueue(this.queueid, mediaBuffer);
            }
            catch (Exception exception) {
                if (this.stopping) break block2;
                exception.printStackTrace();
            }
        }
    }

    public long getQueuedTime() {
        return this.queuedTime;
    }

    public void stop() {
        this.stopping = true;
        QueueManager.unRegisterQueue(this.queueid);
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        try {
            this.realRun();
        }
        catch (Throwable throwable) {
            Cortado.shutdown(throwable);
        }
    }

    private final void handleDisplay(MediaBuffer mediaBuffer) {
        block7: {
            try {
                if (this.frameperiod > 0.0) {
                    long l = mediaBuffer.timestamp;
                    if (l == (long)-1) {
                        l = (long)((double)this.framenr * this.frameperiod);
                    }
                    if (this.clock.waitForMediaTime(l)) {
                        Debug.log(4, "set image " + l);
                        this.target.setImage(mediaBuffer.object, this.framerate, this.aspect);
                    } else {
                        Debug.log(4, "skip image " + l);
                    }
                } else {
                    Debug.log(4, "set image");
                    this.target.setImage(mediaBuffer.object, this.framerate, this.aspect);
                }
            }
            catch (Exception exception) {
                if (this.stopping) break block7;
                exception.printStackTrace();
            }
        }
        ++this.framenr;
        mediaBuffer.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handlePrequeue(MediaBuffer mediaBuffer) {
        boolean bl = false;
        Debug.log(4, "video time: " + mediaBuffer.timestamp + ' ' + mediaBuffer.time_offset + ' ' + this.queuedTime + ' ' + this.framesQueued + ' ' + mediaBuffer.length);
        this.preQueue.addElement(mediaBuffer);
        if (mediaBuffer.timestamp == (long)-1 && mediaBuffer.time_offset == (long)-1) {
            Debug.log(4, "video queueing");
            ++this.framesQueued;
            return;
        }
        MediaBuffer mediaBuffer2 = (MediaBuffer)this.preQueue.elementAt(0);
        if (mediaBuffer.timestamp == (long)-1) {
            mediaBuffer.timestamp = this.plugin.offsetToTime(mediaBuffer.time_offset);
        }
        Debug.log(4, "prebuffer head " + mediaBuffer2.timestamp);
        mediaBuffer2.timestamp = mediaBuffer.timestamp - (long)((double)(this.framesQueued * 1000L) / this.framerate);
        this.framenr = (long)((double)mediaBuffer2.timestamp / this.frameperiod);
        Debug.log(4, "prebuffer head after correction " + mediaBuffer2.timestamp);
        if (!this.ready) {
            try {
                this.target.setImage(mediaBuffer2.object, this.framerate, this.aspect);
                this.queuedTime = mediaBuffer2.timestamp;
                mediaBuffer2.free();
                Clock clock = this.clock;
                synchronized (clock) {
                    this.ready = true;
                    Debug.log(3, "video preroll wait");
                    this.clock.wait();
                    Debug.log(3, "video preroll go!");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++this.framenr;
        }
        int n = 1;
        while (n < this.preQueue.size()) {
            MediaBuffer mediaBuffer3 = (MediaBuffer)this.preQueue.elementAt(n);
            this.handleDisplay(mediaBuffer3);
            ++n;
        }
        this.preQueue.setSize(0);
        this.preQueueing = false;
        this.framesQueued = 0L;
    }

    private final void realRun() {
        Debug.log(3, "entering video thread");
        while (!this.stopping) {
            Debug.log(4, "dequeue image");
            MediaBuffer mediaBuffer = null;
            try {
                mediaBuffer = (MediaBuffer)QueueManager.dequeue(this.queueid);
            }
            catch (InterruptedException interruptedException) {
                if (this.stopping) continue;
                interruptedException.printStackTrace();
                continue;
            }
            Debug.log(4, "dequeued image");
            MediaBuffer mediaBuffer2 = this.plugin.decode(mediaBuffer);
            if (mediaBuffer2 == null) continue;
            Debug.log(4, "decoded image");
            if (this.plugin.fps_numerator > 0) {
                double d = (double)this.plugin.fps_numerator / (double)this.plugin.fps_denominator;
                if (d != this.framerate) {
                    this.framerate = d;
                    this.frameperiod = 1000.0 / d;
                    Debug.log(3, "frameperiod: " + this.frameperiod);
                }
            } else if (this.preQueueing) {
                mediaBuffer2.timestamp = 0L;
            }
            this.aspect = (double)this.plugin.aspect_numerator / (double)this.plugin.aspect_denominator;
            if (this.preQueueing) {
                this.handlePrequeue(mediaBuffer2);
                continue;
            }
            this.handleDisplay(mediaBuffer2);
        }
        Debug.log(3, "exit video thread");
    }

    private final /* synthetic */ void this() {
        this.aspect = 1.0;
        this.stopping = false;
        this.queuedTime = -1;
        this.preQueue = new Vector();
        this.preQueueing = true;
        this.framesQueued = 0L;
    }

    public VideoConsumer(Clock clock, ImageTarget imageTarget, double d) {
        this.this();
        this.target = imageTarget;
        this.component = imageTarget.getComponent();
        this.queueid = QueueManager.registerQueue(100);
        Debug.log(3, "video on queue " + this.queueid);
        this.clock = clock;
        this.frameperiod = d > 0.0 ? 1000.0 / d : -1.0;
    }
}

