/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.Cortado;
import com.fluendo.player.PreBufferNotify;
import com.fluendo.utils.Debug;
import java.io.InputStream;
import java.io.Reader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PreBuffer
extends InputStream
implements Runnable {
    private static int SEGSIZE = 1024;
    private InputStream inputStream;
    private int bufferSize;
    private byte[] buffer;
    private int in;
    private int out;
    private Reader reader;
    private Thread thread;
    private boolean stopping;
    private int low;
    private int high;
    private PreBufferNotify notify;
    private boolean eos;
    private boolean readerBlocked;
    private boolean writerBlocked;
    private long received;
    private long receiveStart;
    private long consumed;
    private int segment;
    private byte[] temp;
    private int state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int free() {
        PreBuffer preBuffer = this;
        synchronized (preBuffer) {
            if (this.in == -1) {
                return this.bufferSize;
            }
            return (this.out + this.bufferSize - this.in) % this.bufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int available() {
        PreBuffer preBuffer = this;
        synchronized (preBuffer) {
            if (this.in == -1) {
                return 0;
            }
            if (this.in == this.out) {
                return this.bufferSize;
            }
            return (this.in + this.bufferSize - this.out) % this.bufferSize;
        }
    }

    public void stop() {
        this.stopping = true;
        try {
            this.thread.interrupt();
        }
        catch (Exception exception) {}
        try {
            this.thread.join();
        }
        catch (Exception exception) {}
    }

    public void run() {
        Thread.currentThread().setPriority(10);
        try {
            this.realRun();
        }
        catch (Throwable throwable) {
            Cortado.shutdown(throwable);
        }
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.available() < this.low) {
            bl = true;
        }
        return bl;
    }

    public boolean isFilled() {
        boolean bl = false;
        if (this.available() >= this.high) {
            bl = true;
        }
        return bl;
    }

    public synchronized int getFilled() {
        return this.available();
    }

    public synchronized long getReceived() {
        return this.received;
    }

    public synchronized double getReceiveSpeed() {
        if (this.receiveStart == 0L) {
            return 0.0;
        }
        long l = System.currentTimeMillis() - this.receiveStart;
        return (double)this.received / (double)l;
    }

    public synchronized double getConsumeSpeed() {
        if (this.receiveStart == 0L) {
            return 0.0;
        }
        long l = System.currentTimeMillis() - this.receiveStart;
        return (double)this.consumed / (double)l;
    }

    private final void checkFilled() {
        if (this.state == 1 && this.isFilled()) {
            this.state = 2;
            if (this.notify != null) {
                this.notify.preBufferNotify(this.state);
            }
        }
    }

    private final void checkEmpty() {
        if (!this.eos && this.state == 2 && this.isEmpty()) {
            this.state = 1;
            if (this.notify != null) {
                this.notify.preBufferNotify(this.state);
            }
        }
    }

    public synchronized void startBuffer() {
        Debug.log(3, "start buffer..");
        this.state = 1;
        this.received = 0L;
        this.receiveStart = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void realRun() {
        Debug.log(3, "entering preroll thread");
        while (!this.stopping) {
            try {
                int n;
                int n2;
                int n3;
                PreBuffer preBuffer = this;
                synchronized (preBuffer) {
                    while (true) {
                        block15: {
                            if (this.free() < this.segment) break block15;
                        }
                        if (this.notify != null) {
                            this.notify.preBufferNotify(3);
                        }
                        this.writerBlocked = true;
                        this.wait();
                        this.writerBlocked = false;
                    }
                    n3 = this.in < 0 ? this.out : this.in;
                    if (n3 + this.segment > this.bufferSize) {
                        n2 = this.bufferSize - n3;
                        n = this.segment - n2;
                    } else {
                        n2 = this.segment;
                        n = 0;
                    }
                }
                int n4 = this.inputStream.read(this.buffer, n3, n2);
                int n5 = n > 0 && n4 == n2 ? this.inputStream.read(this.buffer, 0, n) : 0;
                if (n4 < 0) {
                    this.eos = true;
                    this.in = -1;
                    Debug.log(3, "writer EOS");
                    break;
                }
                int n6 = n5 <= 0 ? n4 : n4 + n5;
                preBuffer = this;
                synchronized (preBuffer) {
                    this.received += (long)n6;
                    this.in = (n3 + n6) % this.bufferSize;
                    this.checkFilled();
                    if (this.readerBlocked) {
                        this.notify();
                    }
                }
            }
            catch (Exception exception) {
                if (this.stopping) continue;
                exception.printStackTrace();
                this.stopping = true;
            }
        }
        Debug.log(3, "exit preroll thread");
    }

    public int read() {
        int n = this.read(this.temp, 0, 1);
        if (n > 0) {
            n = this.temp[0] + 256;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        PreBuffer preBuffer;
        block14: {
            preBuffer = this;
            synchronized (preBuffer) {
                int n5;
                block13: {
                    n5 = this.available();
                    if (!this.eos) break block13;
                    if (n5 == 0) {
                        Debug.log(3, "reader EOS");
                        return -1;
                    }
                    n2 = Math.min(n5, n2);
                }
                while (true) {
                    if (n5 >= n2) {
                        if (this.out + n2 <= this.bufferSize) break;
                        n4 = this.bufferSize - this.out;
                        n3 = n2 - n4;
                        break block14;
                    }
                    try {
                        Debug.log(4, "read: wait available " + n5 + " need " + n2);
                        this.readerBlocked = true;
                        this.wait();
                        this.readerBlocked = false;
                        Debug.log(4, "read: wait done available " + n5 + " need " + n2);
                    }
                    catch (InterruptedException interruptedException) {}
                    n5 = this.available();
                }
                n4 = n2;
                n3 = 0;
            }
        }
        System.arraycopy(this.buffer, this.out, byArray, n, n4);
        if (n3 > 0) {
            System.arraycopy(this.buffer, 0, byArray, n + n4, n3);
        }
        preBuffer = this;
        synchronized (preBuffer) {
            this.out = (this.out + n2) % this.bufferSize;
            this.checkEmpty();
            if (this.writerBlocked) {
                this.notify();
            }
            this.consumed += (long)n2;
            return n2;
        }
    }

    public final void dumpStats() {
        Debug.log(4, "buffer: [in:" + this.getReceived() + ", in-speed:" + this.getReceiveSpeed() + ", avail:" + this.available() + '/' + this.bufferSize + ']');
    }

    private final /* synthetic */ void this() {
        this.stopping = false;
        this.temp = new byte[1];
        this.state = 0;
    }

    public PreBuffer(InputStream inputStream, int n, int n2, int n3, PreBufferNotify preBufferNotify) {
        this.this();
        this.inputStream = inputStream;
        this.in = -1;
        this.out = 0;
        this.notify = preBufferNotify;
        this.low = n * n2 / 100;
        if (this.low <= 0) {
            this.low = 1;
        }
        this.high = n * n3 / 100;
        if (this.high >= n) {
            this.high = n - 1;
        }
        this.eos = false;
        this.segment = Math.max(SEGSIZE, this.low);
        this.bufferSize = n;
        this.buffer = new byte[this.bufferSize];
        this.thread = new Thread(this);
        this.thread.start();
        this.receiveStart = 0L;
    }
}

