/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.AudioConsumer;
import com.fluendo.player.AudioConsumerSun;
import com.fluendo.player.Clock;
import com.fluendo.player.Configure;
import com.fluendo.player.DataConsumer;
import com.fluendo.player.Demuxer;
import com.fluendo.player.ImageTarget;
import com.fluendo.player.Plugin;
import com.fluendo.player.PreBuffer;
import com.fluendo.player.PreBufferNotify;
import com.fluendo.player.QueueManager;
import com.fluendo.player.Status;
import com.fluendo.player.VideoConsumer;
import com.fluendo.utils.Base64Converter;
import com.fluendo.utils.Debug;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageProducer;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Cortado
extends Applet
implements ImageTarget,
PreBufferNotify,
Runnable,
MouseMotionListener,
MouseListener {
    private static Cortado cortado;
    private String urlString;
    private boolean local;
    private double framerate;
    private boolean audio;
    private boolean video;
    private boolean keepAspect;
    private int bufferSize;
    private String userId;
    private String password;
    private boolean usePrebuffer;
    private PreBuffer preBuffer;
    private int bufferLow;
    private int bufferHigh;
    private int debug;
    private double aspect;
    private Image image;
    private ImageProducer imageProd;
    private Thread videoThread;
    private Thread audioThread;
    private Thread mainThread;
    private Thread statusThread;
    private DataConsumer videoConsumer;
    private DataConsumer audioConsumer;
    private Demuxer demuxer;
    private InputStream is;
    private Clock clock;
    private boolean havePreroll;
    private Status status;
    private PopupMenu menu;
    private boolean stopping;
    private Hashtable params;
    private Configure configure;
    private boolean useDb;
    private Dimension dbSize;
    private Image dbImage;
    private Graphics dbGraphics;
    private Dimension appletDimension;
    private boolean needRepaint;

    public String getAppletInfo() {
        return "Title: Fluendo media player \nAuthor: Wim Taymans \nA Java based network multimedia player.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"url", "URL", "The media file to play"}, {"local", "boolean", "Is this a local file (default false)"}, {"framerate", "float", "The default framerate of the video (default 5.0)"}, {"audio", "boolean", "Enable audio playback (default true)"}, {"video", "boolean", "Enable video playback (default true)"}, {"keepAspect", "boolean", "Use aspect ratio of video (default true)"}, {"preBuffer", "boolean", "Use Prebuffering (default = true)"}, {"doubleBuffer", "boolean", "Use double buffering for screen updates (default = true)"}, {"bufferSize", "int", "The size of the prebuffer in Kbytes (default 100)"}, {"bufferLow", "int", "Percent of empty buffer (default 10)"}, {"bufferHigh", "int", "Percent of full buffer (default 70)"}, {"userId", "string", "userId for basic authentication (default null)"}, {"password", "string", "password for basic authentication (default null)"}, {"debug", "int", "Debug level 0 - 4 (default = 3)"}};
        return stringArray;
    }

    public void setParam(String string, String string2) {
        this.params.put(string, string2);
    }

    public void restart() {
        this.stop();
        this.init();
        this.start();
    }

    public String getParam(String string, String string2) {
        String string3 = (String)this.params.get(string);
        if (string3 == null) {
            try {
                string3 = this.getParameter(string);
            }
            catch (Exception exception) {}
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static void shutdown(Throwable throwable) {
        Debug.log(3, "shutting down: reason: " + throwable.getMessage());
        throwable.printStackTrace();
        cortado.stop();
    }

    public void init() {
        cortado = this;
        this.image = null;
        this.aspect = 0.0;
        this.is = null;
        this.clock = null;
        this.preBuffer = null;
        this.urlString = this.getParam("url", null);
        this.local = String.valueOf(this.getParam("local", "false")).equals("true");
        this.framerate = Double.valueOf(this.getParam("framerate", "5.0"));
        this.audio = String.valueOf(this.getParam("audio", "true")).equals("true");
        this.video = String.valueOf(this.getParam("video", "true")).equals("true");
        this.keepAspect = String.valueOf(this.getParam("keepAspect", "true")).equals("true");
        this.usePrebuffer = String.valueOf(this.getParam("preBuffer", "true")).equals("true");
        this.useDb = String.valueOf(this.getParam("doubleBuffer", "true")).equals("true");
        this.bufferSize = Integer.valueOf(this.getParam("bufferSize", "200"));
        this.bufferLow = Integer.valueOf(this.getParam("bufferLow", "10"));
        this.bufferHigh = Integer.valueOf(this.getParam("bufferHigh", "70"));
        this.debug = Integer.valueOf(this.getParam("debug", "3"));
        this.userId = this.getParam("userId", null);
        this.password = this.getParam("password", null);
        this.configure = new Configure();
        Debug.level = this.debug;
        Debug.log(2, "build info: " + this.configure.buildInfo);
        this.needRepaint = true;
        this.appletDimension = this.getSize();
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.status = new Status(this);
        this.status.setVisible(true);
        this.status.setHaveAudio(this.audio);
        this.menu = new PopupMenu();
        this.menu.add("About...");
        this.add(this.menu);
    }

    public Component getComponent() {
        return this;
    }

    public synchronized void update(Graphics graphics) {
        if (!this.needRepaint) {
            return;
        }
        if (this.useDb) {
            boolean bl;
            if (this.appletDimension == null) {
                this.appletDimension = this.getSize();
            }
            boolean bl2 = false;
            if (this.dbImage == null || this.dbSize.height != this.appletDimension.height || this.dbSize.width != this.appletDimension.width) {
                bl2 = true;
            }
            if (bl = bl2) {
                this.dbSize = this.appletDimension;
                this.dbImage = this.createImage(this.dbSize.width, this.dbSize.height);
                this.dbGraphics = this.dbImage.getGraphics();
            }
            this.dbGraphics.setColor(this.getBackground());
            this.dbGraphics.fillRect(0, 0, this.dbSize.width, this.dbSize.height);
            this.dbGraphics.setColor(Color.black);
            this.dbGraphics.setFont(this.getFont());
            this.paint(this.dbGraphics);
            graphics.drawImage(this.dbImage, 0, 0, null);
        } else {
            this.paint(graphics);
        }
    }

    public void run() {
        try {
            this.realRun();
        }
        catch (Throwable throwable) {
            Cortado.shutdown(throwable);
        }
    }

    private final void realRun() {
        Debug.log(3, "entering status thread");
        while (!this.stopping) {
            try {
                if (this.preBuffer != null) {
                    int n = this.preBuffer.getFilled() * 100 / (1024 * this.bufferSize);
                    if (this.status.isVisible()) {
                        this.status.setBufferPercent(n);
                        this.forceRepaint();
                    }
                    this.preBuffer.dumpStats();
                    QueueManager.dumpStats();
                }
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                if (this.stopping) continue;
                exception.printStackTrace();
            }
        }
        Debug.log(3, "exit status thread");
    }

    public synchronized void paint(Graphics graphics) {
        if (this.appletDimension == null) {
            this.appletDimension = this.getSize();
        }
        int n = this.appletDimension.width;
        int n2 = this.appletDimension.height;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        if (this.image != null) {
            double d;
            int n6 = n2;
            int n7 = this.image.getWidth(this);
            int n8 = this.image.getHeight(this);
            if (this.keepAspect && (n6 = (int)((double)n5 / (d = (double)n7 / (double)n8 * this.aspect))) > n2) {
                n6 = n2;
                n5 = (int)((double)n6 * d);
            }
            n3 = (n - n5) / 2;
            n4 = (n2 - n6) / 2;
            if (this.status.isVisible()) {
                graphics.setClip(n3, n4, n5, n2 - 12 - n4);
                graphics.drawImage(this.image, n3, n4, n5, n6, null);
                graphics.setClip(0, 0, n, n2);
            } else {
                graphics.drawImage(this.image, n3, n4, n5, n6, null);
                graphics.setColor(Color.black);
                int n9 = Math.max(n4 + n6, n2 - 12);
                graphics.fillRect(n3, n9, n3 + n5, n2);
            }
            this.image.flush();
        }
        if (this.status != null && this.status.isVisible()) {
            this.status.setBounds(n3, n2 - 12, n5, 12);
            this.status.paint(graphics);
        }
        this.needRepaint = false;
    }

    private final synchronized void forceRepaint() {
        this.needRepaint = true;
        this.repaint();
    }

    public synchronized void setImage(Object object, double d, double d2) {
        if (object instanceof Image) {
            this.setImage((Image)object, d, d2);
        } else if (object instanceof ImageProducer) {
            this.setImage((ImageProducer)object, d, d2);
        }
    }

    public synchronized void setImage(ImageProducer imageProducer, double d, double d2) {
        if (!this.needRepaint) {
            if (this.imageProd != imageProducer) {
                this.image = this.createImage(imageProducer);
                this.imageProd = imageProducer;
            }
            this.setImage(this.image, d, d2);
        }
    }

    public synchronized void setImage(Image image, double d, double d2) {
        if (!this.needRepaint) {
            this.image = image;
            this.framerate = d;
            this.aspect = d2;
            if (!this.havePreroll) {
                int n = this.appletDimension.width;
                int n2 = this.appletDimension.height;
                this.getGraphics().clearRect(0, 0, n, n2);
                this.status.setMessage("Buffering...");
            }
            this.forceRepaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void preBufferNotify(int n) {
        String string = null;
        PreBuffer preBuffer = this.preBuffer;
        synchronized (preBuffer) {
            if (!this.havePreroll && n != 1) {
                return;
            }
            switch (n) {
                case 1: {
                    string = "Buffering...";
                    this.status.setVisible(true);
                    this.clock.pause();
                    break;
                }
                case 2: {
                    string = "Playing...";
                    this.clock.play();
                    this.status.setVisible(false);
                    break;
                }
                case 3: {
                    this.clock.play();
                    break;
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
            if (string == null) {
                return;
            }
            this.status.setMessage(string);
            this.forceRepaint();
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.status.setVisible(false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) == 4) {
            this.menu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.status != null) {
            if (mouseEvent.getY() > this.appletDimension.height - 12) {
                this.status.setVisible(true);
            } else {
                this.status.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        this.stopping = false;
        Plugin plugin = null;
        this.status.setMessage("Opening " + this.urlString + "...");
        this.addMouseListener(this);
        try {
            int n;
            Object object;
            Object object2;
            try {
                if (this.local) {
                    Debug.log(3, "reading from file " + this.urlString);
                    this.is = new FileInputStream(this.urlString);
                } else {
                    String string;
                    Debug.log(3, "reading from url " + this.urlString);
                    object2 = new URL(this.urlString);
                    Debug.log(3, "trying to open " + object2);
                    object = ((URL)object2).openConnection();
                    if (this.userId != null && this.password != null) {
                        string = this.userId + ':' + this.password;
                        String string2 = Base64Converter.encode(string.getBytes());
                        ((URLConnection)object).setRequestProperty("Authorization", "Basic " + string2);
                    }
                    if ((string = ((URLConnection)object).getContentType()) == null) {
                        string = "application/ogg";
                        Debug.log(3, "could not get mime type, using: " + string);
                    }
                    if ((n = string.indexOf(59)) != -1) {
                        string = string.substring(0, n);
                    }
                    Debug.log(3, "got stream mime: " + string);
                    plugin = Plugin.makeByMime(string);
                    if (plugin == null) {
                        this.status.setMessage("Unknown stream " + this.urlString + "...");
                        return;
                    }
                    this.is = ((URLConnection)object).getInputStream();
                    Debug.log(3, "opened " + object2);
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                this.status.setMessage("Not allowed " + this.urlString + "...");
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.status.setMessage("Failed opening " + this.urlString + "...");
                return;
            }
            this.status.setMessage("Loading media...");
            this.clock = new Clock();
            this.addMouseMotionListener(this);
            if (this.video) {
                this.videoConsumer = new VideoConsumer(this.clock, this, this.framerate);
                this.videoThread = new Thread(this.videoConsumer);
            }
            if (this.audio) {
                try {
                    Class.forName("javax.sound.sampled.AudioSystem");
                    Debug.log(3, "using high quality javax.sound.* as audio backend");
                    this.audioConsumer = new AudioConsumer(this.clock);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Debug.log(3, "using low quality sun.audio.* as audio backend");
                    this.audioConsumer = new AudioConsumerSun(this.clock);
                }
                this.audioThread = new Thread(this.audioConsumer);
            }
            if (plugin == null) {
                plugin = Plugin.makeByMime("application/ogg");
            }
            if (this.usePrebuffer) {
                this.preBuffer = new PreBuffer(this.is, 1024 * this.bufferSize, this.bufferLow, this.bufferHigh, this);
                object2 = this.preBuffer;
            } else {
                object2 = this.is;
            }
            this.demuxer = new Demuxer((InputStream)object2, plugin, this, this.audioConsumer, this.videoConsumer);
            this.mainThread = new Thread(this.demuxer);
            this.statusThread = new Thread(this);
            this.statusThread.start();
            if (this.audio) {
                this.audioThread.start();
            }
            if (this.video) {
                this.videoThread.start();
            }
            try {
                long l;
                block37: {
                    object = Thread.currentThread();
                    synchronized (object) {
                        this.mainThread.start();
                    }
                    object = this.clock;
                    synchronized (object) {
                        this.havePreroll = false;
                        Debug.log(3, "waiting for preroll...");
                        do {
                            n = 1;
                            if (this.video) {
                                n &= this.videoConsumer.isReady();
                            }
                            if (this.audio) {
                                n &= this.audioConsumer.isReady();
                            }
                            if (n != 0) continue;
                            this.clock.wait(100L);
                        } while (n == 0);
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 5, 8] lbl96 : MonitorExitStatement: MONITOREXIT : var3_7
                        this.havePreroll = true;
                        l = 0L;
                        if (!this.video) break block37;
                        l = this.videoConsumer.getQueuedTime();
                    }
                    Debug.log(3, "video timeBase: " + l);
                }
                if (this.audio) {
                    l = this.audioConsumer.getQueuedTime();
                    Debug.log(3, "audio timeBase: " + l);
                }
                this.clock.updateAdjust(l);
                if (this.preBuffer == null) {
                    Debug.log(3, "consumers ready");
                    Debug.log(3, "preroll done, starting...");
                    this.status.setVisible(false);
                    this.status.setMessage("Playing...");
                    this.clock.play();
                    return;
                }
                PreBuffer preBuffer = this.preBuffer;
                synchronized (preBuffer) {
                    block39: {
                        block38: {
                            Debug.log(3, "consumers ready");
                            Debug.log(3, "preroll done, starting prebuffer...");
                            this.status.setHavePercent(this.usePrebuffer);
                            this.preBuffer.startBuffer();
                            if (!this.preBuffer.isFilled()) break block38;
                            this.clock.play();
                            break block39;
                        }
                        Debug.log(3, "not buffered, not starting yet " + this.preBuffer.getFilled());
                    }
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.status.setMessage("Failed opening " + this.urlString + "...");
            this.stop();
        }
    }

    private final void interruptThread(Thread thread) {
        try {
            if (thread != null) {
                thread.interrupt();
            }
        }
        catch (Exception exception) {}
    }

    private final void joinThread(Thread thread) {
        try {
            if (thread != null) {
                thread.join();
            }
        }
        catch (Exception exception) {}
    }

    public void stop() {
        if (this.demuxer != null) {
            this.demuxer.stop();
        }
        try {
            this.stopping = true;
            if (this.preBuffer != null) {
                this.preBuffer.stop();
            }
            if (this.video && this.videoConsumer != null) {
                this.videoConsumer.stop();
            }
            if (this.audio && this.audioConsumer != null) {
                this.audioConsumer.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.video) {
            this.interruptThread(this.videoThread);
        }
        if (this.audio) {
            this.interruptThread(this.audioThread);
        }
        this.interruptThread(this.mainThread);
        this.interruptThread(this.statusThread);
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.video) {
            this.joinThread(this.videoThread);
        }
        if (this.audio) {
            this.joinThread(this.audioThread);
        }
        this.joinThread(this.mainThread);
        this.joinThread(this.statusThread);
        QueueManager.reset();
    }

    private final /* synthetic */ void this() {
        this.params = new Hashtable();
        this.useDb = true;
    }

    public Cortado() {
        this.this();
    }
}

