/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.ClockProvider;
import com.fluendo.player.SystemClock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Clock {
    private long adjust;
    private long startTime;
    private long lastMedia;
    private boolean paused;
    private ClockProvider provider;

    public synchronized void pause() {
        if (!this.paused) {
            this.paused = true;
            this.lastMedia = this.getMediaTime() - this.adjust;
            this.notifyAll();
        }
    }

    public synchronized void setProvider(ClockProvider clockProvider) {
        this.provider = clockProvider;
    }

    public synchronized void play() {
        if (this.paused) {
            long l = this.provider.getTime();
            if (this.startTime == 0L) {
                this.startTime = l;
            }
            long l2 = this.getMediaTime() - this.adjust;
            long l3 = l2 - this.lastMedia;
            this.paused = false;
            this.startTime += l3;
            this.notifyAll();
        }
    }

    public synchronized long getElapsedTime() {
        return this.provider.getTime() - this.startTime;
    }

    public synchronized long getMediaTime() {
        return this.provider.getTime() - this.startTime + this.adjust;
    }

    public synchronized void updateAdjust(long l) {
        this.adjust += l;
        this.notifyAll();
    }

    public synchronized void setAdjust(long l) {
        this.adjust = l;
        this.notifyAll();
    }

    public long getAdjust() {
        return this.adjust;
    }

    public synchronized void checkPlay() throws InterruptedException {
        while (this.paused) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitForMediaTime(long l) throws InterruptedException {
        boolean bl = false;
        this.checkPlay();
        long l2;
        long l3;
        while ((l3 = l - (l2 = this.getMediaTime())) > 0L) {
            bl = true;
            Clock clock = this;
            synchronized (clock) {
                this.wait(l3);
            }
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.paused = true;
    }

    public Clock() {
        this.this();
        this.provider = new SystemClock();
    }
}

