/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.Clock;
import com.fluendo.player.ClockProvider;
import com.fluendo.player.Cortado;
import com.fluendo.player.DataConsumer;
import com.fluendo.player.MediaBuffer;
import com.fluendo.player.Plugin;
import com.fluendo.player.QueueManager;
import com.fluendo.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AudioConsumerSun
implements Runnable,
DataConsumer,
ClockProvider {
    private static final int MAX_BUFFER = 5;
    private static final long DEVICE_BUFFER = 8192L;
    private static final boolean ZEROTRAP = true;
    private static final short BIAS = 132;
    private static final int CLIP = 32635;
    private static final byte[] exp_lut;
    private static final int[] header;
    private int queueid;
    private boolean ready;
    private Clock clock;
    private boolean stopping;
    private Plugin plugin;
    private long queuedTime;
    private Vector preQueue;
    private boolean preQueueing;
    private long samplesQueued;
    private long sampleCount;
    private long nextSampleCount;
    private AudioBuffer audioBuffer;
    private AudioStream audioStream;

    public boolean isReady() {
        return this.ready;
    }

    public long getQueuedTime() {
        return this.queuedTime - 1024L;
    }

    public void stop() {
        this.stopping = true;
        QueueManager.unRegisterQueue(this.queueid);
        AudioPlayer.player.stop((InputStream)this.audioStream);
    }

    public void run() {
        try {
            this.realRun();
        }
        catch (Throwable throwable) {
            Cortado.shutdown(throwable);
        }
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public void consume(MediaBuffer mediaBuffer) {
        block2: {
            try {
                QueueManager.enqueue(this.queueid, mediaBuffer);
            }
            catch (Exception exception) {
                if (this.stopping) break block2;
                exception.printStackTrace();
            }
        }
    }

    public long getTime() {
        return 0L;
    }

    public void checkClockAdjust() {
        long l;
        if (this.audioBuffer == null) {
            return;
        }
        long l2 = this.audioBuffer.getFramePosition() * 1000L / 8000L + this.queuedTime;
        long l3 = this.clock.getMediaTime();
        long l4 = l3 - l2;
        long l5 = Math.abs(l4);
        if (l5 > (l = 100L)) {
            long l6 = (long)(Math.log(l5 - l) * 20.0);
            if (l4 > 0L) {
                this.clock.updateAdjust(-l6);
            } else if (l4 < 0L) {
                this.clock.updateAdjust(l6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handlePrequeue(MediaBuffer mediaBuffer) {
        boolean bl = false;
        this.samplesQueued += (long)(mediaBuffer.length / (2 * this.plugin.channels));
        this.preQueue.addElement(mediaBuffer);
        if (mediaBuffer.time_offset == (long)-1) {
            if (mediaBuffer.time_offset == (long)-1) return;
        }
        MediaBuffer mediaBuffer2 = (MediaBuffer)this.preQueue.elementAt(0);
        if (mediaBuffer.timestamp == (long)-1) {
            mediaBuffer.timestamp = this.plugin.offsetToTime(mediaBuffer.time_offset);
        }
        mediaBuffer2.timestamp = mediaBuffer.timestamp - this.samplesQueued * 1000L / (long)this.plugin.rate;
        this.audioBuffer = new AudioBuffer(100000, this.plugin.rate, this.plugin.channels);
        this.queuedTime = mediaBuffer2.timestamp;
        try {
            int n = 0;
            while (n < this.preQueue.size()) {
                MediaBuffer mediaBuffer3 = (MediaBuffer)this.preQueue.elementAt(n);
                this.audioBuffer.write(mediaBuffer3.data, mediaBuffer3.offset, mediaBuffer3.length);
                this.sampleCount += (long)(mediaBuffer3.length / (2 * this.plugin.channels));
                mediaBuffer3.free();
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.preQueue.setSize(0);
        this.preQueueing = false;
        this.samplesQueued = 0L;
        if (this.ready) return;
        try {
            Clock clock = this.clock;
            synchronized (clock) {
                this.ready = true;
                Debug.log(3, "audio preroll wait");
                this.clock.wait();
                Debug.log(3, "audio preroll go!");
                this.audioBuffer.start();
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void realRun() {
        Debug.log(3, "entering audio thread");
        while (!this.stopping) {
            MediaBuffer mediaBuffer = null;
            try {
                mediaBuffer = (MediaBuffer)QueueManager.dequeue(this.queueid);
            }
            catch (InterruptedException interruptedException) {
                if (this.stopping) continue;
                interruptedException.printStackTrace();
                continue;
            }
            MediaBuffer mediaBuffer2 = this.plugin.decode(mediaBuffer);
            if (mediaBuffer2 == null) continue;
            if (this.preQueueing) {
                this.handlePrequeue(mediaBuffer2);
                continue;
            }
            try {
                this.clock.checkPlay();
                this.audioBuffer.write(mediaBuffer2.data, mediaBuffer2.offset, mediaBuffer2.length);
                this.sampleCount += (long)(mediaBuffer2.length / (2 * this.plugin.channels));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            mediaBuffer2.free();
        }
        Debug.log(3, "exit audio thread");
    }

    static /* synthetic */ long access$2() {
        return 8192L;
    }

    static /* synthetic */ int access$3() {
        return 32635;
    }

    static /* synthetic */ short access$4() {
        return 132;
    }

    static /* synthetic */ boolean access$6() {
        return true;
    }

    private final /* synthetic */ void this() {
        this.stopping = false;
        this.queuedTime = -1;
        this.preQueue = new Vector();
        this.preQueueing = true;
        this.samplesQueued = 0L;
        this.sampleCount = 0L;
        this.nextSampleCount = 0L;
    }

    public AudioConsumerSun(Clock clock) {
        this.this();
        this.queueid = QueueManager.registerQueue(5);
        Debug.log(3, "audio on queue " + this.queueid);
        this.clock = clock;
    }

    static {
        byte[] byArray = new byte[256];
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 2;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 2;
        byArray[8] = 3;
        byArray[9] = 3;
        byArray[10] = 3;
        byArray[11] = 3;
        byArray[12] = 3;
        byArray[13] = 3;
        byArray[14] = 3;
        byArray[15] = 3;
        byArray[16] = 4;
        byArray[17] = 4;
        byArray[18] = 4;
        byArray[19] = 4;
        byArray[20] = 4;
        byArray[21] = 4;
        byArray[22] = 4;
        byArray[23] = 4;
        byArray[24] = 4;
        byArray[25] = 4;
        byArray[26] = 4;
        byArray[27] = 4;
        byArray[28] = 4;
        byArray[29] = 4;
        byArray[30] = 4;
        byArray[31] = 4;
        byArray[32] = 5;
        byArray[33] = 5;
        byArray[34] = 5;
        byArray[35] = 5;
        byArray[36] = 5;
        byArray[37] = 5;
        byArray[38] = 5;
        byArray[39] = 5;
        byArray[40] = 5;
        byArray[41] = 5;
        byArray[42] = 5;
        byArray[43] = 5;
        byArray[44] = 5;
        byArray[45] = 5;
        byArray[46] = 5;
        byArray[47] = 5;
        byArray[48] = 5;
        byArray[49] = 5;
        byArray[50] = 5;
        byArray[51] = 5;
        byArray[52] = 5;
        byArray[53] = 5;
        byArray[54] = 5;
        byArray[55] = 5;
        byArray[56] = 5;
        byArray[57] = 5;
        byArray[58] = 5;
        byArray[59] = 5;
        byArray[60] = 5;
        byArray[61] = 5;
        byArray[62] = 5;
        byArray[63] = 5;
        byArray[64] = 6;
        byArray[65] = 6;
        byArray[66] = 6;
        byArray[67] = 6;
        byArray[68] = 6;
        byArray[69] = 6;
        byArray[70] = 6;
        byArray[71] = 6;
        byArray[72] = 6;
        byArray[73] = 6;
        byArray[74] = 6;
        byArray[75] = 6;
        byArray[76] = 6;
        byArray[77] = 6;
        byArray[78] = 6;
        byArray[79] = 6;
        byArray[80] = 6;
        byArray[81] = 6;
        byArray[82] = 6;
        byArray[83] = 6;
        byArray[84] = 6;
        byArray[85] = 6;
        byArray[86] = 6;
        byArray[87] = 6;
        byArray[88] = 6;
        byArray[89] = 6;
        byArray[90] = 6;
        byArray[91] = 6;
        byArray[92] = 6;
        byArray[93] = 6;
        byArray[94] = 6;
        byArray[95] = 6;
        byArray[96] = 6;
        byArray[97] = 6;
        byArray[98] = 6;
        byArray[99] = 6;
        byArray[100] = 6;
        byArray[101] = 6;
        byArray[102] = 6;
        byArray[103] = 6;
        byArray[104] = 6;
        byArray[105] = 6;
        byArray[106] = 6;
        byArray[107] = 6;
        byArray[108] = 6;
        byArray[109] = 6;
        byArray[110] = 6;
        byArray[111] = 6;
        byArray[112] = 6;
        byArray[113] = 6;
        byArray[114] = 6;
        byArray[115] = 6;
        byArray[116] = 6;
        byArray[117] = 6;
        byArray[118] = 6;
        byArray[119] = 6;
        byArray[120] = 6;
        byArray[121] = 6;
        byArray[122] = 6;
        byArray[123] = 6;
        byArray[124] = 6;
        byArray[125] = 6;
        byArray[126] = 6;
        byArray[127] = 6;
        byArray[128] = 7;
        byArray[129] = 7;
        byArray[130] = 7;
        byArray[131] = 7;
        byArray[132] = 7;
        byArray[133] = 7;
        byArray[134] = 7;
        byArray[135] = 7;
        byArray[136] = 7;
        byArray[137] = 7;
        byArray[138] = 7;
        byArray[139] = 7;
        byArray[140] = 7;
        byArray[141] = 7;
        byArray[142] = 7;
        byArray[143] = 7;
        byArray[144] = 7;
        byArray[145] = 7;
        byArray[146] = 7;
        byArray[147] = 7;
        byArray[148] = 7;
        byArray[149] = 7;
        byArray[150] = 7;
        byArray[151] = 7;
        byArray[152] = 7;
        byArray[153] = 7;
        byArray[154] = 7;
        byArray[155] = 7;
        byArray[156] = 7;
        byArray[157] = 7;
        byArray[158] = 7;
        byArray[159] = 7;
        byArray[160] = 7;
        byArray[161] = 7;
        byArray[162] = 7;
        byArray[163] = 7;
        byArray[164] = 7;
        byArray[165] = 7;
        byArray[166] = 7;
        byArray[167] = 7;
        byArray[168] = 7;
        byArray[169] = 7;
        byArray[170] = 7;
        byArray[171] = 7;
        byArray[172] = 7;
        byArray[173] = 7;
        byArray[174] = 7;
        byArray[175] = 7;
        byArray[176] = 7;
        byArray[177] = 7;
        byArray[178] = 7;
        byArray[179] = 7;
        byArray[180] = 7;
        byArray[181] = 7;
        byArray[182] = 7;
        byArray[183] = 7;
        byArray[184] = 7;
        byArray[185] = 7;
        byArray[186] = 7;
        byArray[187] = 7;
        byArray[188] = 7;
        byArray[189] = 7;
        byArray[190] = 7;
        byArray[191] = 7;
        byArray[192] = 7;
        byArray[193] = 7;
        byArray[194] = 7;
        byArray[195] = 7;
        byArray[196] = 7;
        byArray[197] = 7;
        byArray[198] = 7;
        byArray[199] = 7;
        byArray[200] = 7;
        byArray[201] = 7;
        byArray[202] = 7;
        byArray[203] = 7;
        byArray[204] = 7;
        byArray[205] = 7;
        byArray[206] = 7;
        byArray[207] = 7;
        byArray[208] = 7;
        byArray[209] = 7;
        byArray[210] = 7;
        byArray[211] = 7;
        byArray[212] = 7;
        byArray[213] = 7;
        byArray[214] = 7;
        byArray[215] = 7;
        byArray[216] = 7;
        byArray[217] = 7;
        byArray[218] = 7;
        byArray[219] = 7;
        byArray[220] = 7;
        byArray[221] = 7;
        byArray[222] = 7;
        byArray[223] = 7;
        byArray[224] = 7;
        byArray[225] = 7;
        byArray[226] = 7;
        byArray[227] = 7;
        byArray[228] = 7;
        byArray[229] = 7;
        byArray[230] = 7;
        byArray[231] = 7;
        byArray[232] = 7;
        byArray[233] = 7;
        byArray[234] = 7;
        byArray[235] = 7;
        byArray[236] = 7;
        byArray[237] = 7;
        byArray[238] = 7;
        byArray[239] = 7;
        byArray[240] = 7;
        byArray[241] = 7;
        byArray[242] = 7;
        byArray[243] = 7;
        byArray[244] = 7;
        byArray[245] = 7;
        byArray[246] = 7;
        byArray[247] = 7;
        byArray[248] = 7;
        byArray[249] = 7;
        byArray[250] = 7;
        byArray[251] = 7;
        byArray[252] = 7;
        byArray[253] = 7;
        byArray[254] = 7;
        byArray[255] = 7;
        exp_lut = byArray;
        int[] nArray = new int[24];
        nArray[0] = 46;
        nArray[1] = 115;
        nArray[2] = 110;
        nArray[3] = 100;
        nArray[7] = 24;
        nArray[8] = 127;
        nArray[9] = 255;
        nArray[10] = 255;
        nArray[11] = 255;
        nArray[15] = 1;
        nArray[18] = 31;
        nArray[19] = 64;
        nArray[23] = 1;
        header = nArray;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AudioBuffer
    extends InputStream {
        private int readPtr;
        private int writePtr;
        private int rate;
        private int channels;
        private byte[] buffer;
        private boolean started;
        private boolean needHeader;
        private int resampleWrap;
        private long samplesRead;
        private long samplesWritten;
        private long free;

        public int available() throws IOException {
            return super.available();
        }

        public long getFramePosition() {
            return this.samplesRead - 8192L;
        }

        public void start() {
            this.started = true;
        }

        private final byte toUlaw(int n) {
            int n2;
            byte by;
            int n3;
            if (n > Short.MAX_VALUE) {
                n = Short.MAX_VALUE;
            } else if (n < Short.MIN_VALUE) {
                n = Short.MIN_VALUE;
            }
            int n4 = n >> 8 & 0x80;
            if (n4 != 0) {
                n = -n;
            }
            if (n > 32635) {
                n = 32635;
            }
            if ((n3 = ~(n4 | (by = exp_lut[(n += 132) >> 7 & 0xFF]) << 4 | (n2 = n >> by + 3 & 0xF))) == 0) {
                n3 = 2;
            }
            return (byte)n3;
        }

        public int read() {
            int n;
            if (this.needHeader) {
                n = header[this.readPtr];
                ++this.readPtr;
                if (this.readPtr >= header.length) {
                    this.readPtr = 0;
                    this.needHeader = false;
                }
            } else if (!this.started) {
                n = 127;
            } else {
                n = this.buffer[this.readPtr];
                if (n < 0) {
                    n += 256;
                }
                this.buffer[this.readPtr++] = 127;
                ++this.free;
                if (this.free >= (long)this.buffer.length) {
                    this.free = this.buffer.length - 1;
                    ++this.writePtr;
                }
                if (this.readPtr >= this.buffer.length) {
                    this.readPtr = 0;
                }
                ++this.samplesRead;
            }
            return n;
        }

        public synchronized int read(byte[] byArray) throws IOException {
            if (this.started) {
                AudioConsumerSun.this.checkClockAdjust();
            }
            if (AudioConsumerSun.this.stopping) {
                return -1;
            }
            int n = super.read(byArray);
            this.notify();
            return n;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.started) {
                AudioConsumerSun.this.checkClockAdjust();
            }
            if (AudioConsumerSun.this.stopping) {
                return -1;
            }
            int n3 = super.read(byArray, n, n2);
            this.notify();
            return n3;
        }

        public synchronized int write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            int n4 = n2 / (2 * this.channels);
            while (this.free < (long)n4) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            int n5 = this.resampleWrap;
            while (n5 < n2) {
                int n6 = 0;
                int n7 = 0;
                while (n7 < this.channels) {
                    byte by = byArray[n + n5 + 2 * n7];
                    int n8 = byArray[n + n5 + 1 + 2 * n7];
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    n6 += by * 256 | n8;
                    ++n7;
                }
                this.buffer[this.writePtr] = this.toUlaw(n6 /= this.channels);
                if (++this.writePtr >= this.buffer.length) {
                    this.writePtr = 0;
                }
                --this.free;
                n5 = 2 * this.channels * (this.rate * ++n3 / 8000);
            }
            this.resampleWrap = n5 - n2;
            return n2;
        }

        private final /* synthetic */ void this() {
            this.needHeader = true;
        }

        public AudioBuffer(int n, int n2, int n3) {
            this.this();
            this.readPtr = 0;
            this.writePtr = 0;
            this.rate = n2;
            this.channels = n3;
            this.buffer = new byte[n];
            int n4 = 0;
            while (n4 < this.buffer.length) {
                this.buffer[n4] = 127;
                ++n4;
            }
            this.started = false;
            this.free = n;
            try {
                AudioConsumerSun.this.audioStream = new AudioStream((InputStream)this);
                AudioPlayer.player.start((InputStream)AudioConsumerSun.this.audioStream);
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

