/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.Clock;
import com.fluendo.player.ClockProvider;
import com.fluendo.player.Cortado;
import com.fluendo.player.DataConsumer;
import com.fluendo.player.MediaBuffer;
import com.fluendo.player.Plugin;
import com.fluendo.player.QueueManager;
import com.fluendo.utils.Debug;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AudioConsumer
implements Runnable,
DataConsumer,
ClockProvider {
    private static final int MAX_BUFFER = 5;
    private int queueid;
    private boolean ready;
    private Clock clock;
    private boolean stopping;
    private Plugin plugin;
    private long queuedTime;
    private Vector preQueue;
    private boolean preQueueing;
    private long samplesQueued;
    private long sampleCount;
    private long nextSampleCount;
    private SourceDataLine line;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public boolean isReady() {
        boolean bl = false;
        if (this.ready && QueueManager.isFilled(this.queueid)) {
            bl = true;
        }
        return bl;
    }

    public long getQueuedTime() {
        return this.queuedTime;
    }

    public void stop() {
        this.stopping = true;
        QueueManager.unRegisterQueue(this.queueid);
    }

    public void run() {
        try {
            this.realRun();
        }
        catch (Throwable throwable) {
            Cortado.shutdown(throwable);
        }
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public void consume(MediaBuffer mediaBuffer) {
        block2: {
            try {
                QueueManager.enqueue(this.queueid, mediaBuffer);
            }
            catch (Exception exception) {
                if (this.stopping) break block2;
                exception.printStackTrace();
            }
        }
    }

    public long getTime() {
        return this.line.getMicrosecondPosition() / 1000L;
    }

    public void checkClockAdjust() {
        if (this.sampleCount > this.nextSampleCount) {
            long l;
            long l2 = (long)this.line.getFramePosition() * 1000L / (long)this.plugin.rate + this.queuedTime;
            long l3 = this.clock.getMediaTime();
            long l4 = l3 - l2;
            long l5 = Math.abs(l4);
            if (l5 > (l = 100L)) {
                long l6 = (long)(Math.log(l5 - l) * 20.0);
                if (l4 > 0L) {
                    this.clock.updateAdjust(-l6);
                } else if (l4 < 0L) {
                    this.clock.updateAdjust(l6);
                }
            }
            this.nextSampleCount = this.sampleCount + (long)this.plugin.rate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handlePrequeue(MediaBuffer mediaBuffer) {
        boolean bl = false;
        this.samplesQueued += (long)(mediaBuffer.length / (2 * this.plugin.channels));
        this.preQueue.addElement(mediaBuffer);
        if (mediaBuffer.time_offset == (long)-1) {
            if (mediaBuffer.time_offset == (long)-1) return;
        }
        MediaBuffer mediaBuffer2 = (MediaBuffer)this.preQueue.elementAt(0);
        if (mediaBuffer.timestamp == (long)-1) {
            mediaBuffer.timestamp = this.plugin.offsetToTime(mediaBuffer.time_offset);
        }
        mediaBuffer2.timestamp = mediaBuffer.timestamp - this.samplesQueued * 1000L / (long)this.plugin.rate;
        AudioFormat audioFormat = new AudioFormat(this.plugin.rate, 16, this.plugin.channels, true, true);
        Class clazz = class$javax$sound$sampled$SourceDataLine;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$SourceDataLine = AudioConsumer.class("[Ljavax.sound.sampled.SourceDataLine;", false);
        }
        DataLine.Info info = new DataLine.Info(clazz, audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
            Debug.log(3, "line info: available: " + this.line.available());
            Debug.log(3, "line info: buffer: " + this.line.getBufferSize());
            Debug.log(3, "line info: framePosition: " + this.line.getFramePosition());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.queuedTime = mediaBuffer2.timestamp;
        try {
            int n = 0;
            while (n < this.preQueue.size()) {
                MediaBuffer mediaBuffer3 = (MediaBuffer)this.preQueue.elementAt(n);
                this.line.write(mediaBuffer3.data, mediaBuffer3.offset, mediaBuffer3.length);
                this.sampleCount += (long)(mediaBuffer3.length / (2 * this.plugin.channels));
                mediaBuffer3.free();
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.preQueue.setSize(0);
        this.preQueueing = false;
        this.samplesQueued = 0L;
        if (this.ready) return;
        try {
            this.ready = true;
            Clock clock = this.clock;
            synchronized (clock) {
                Debug.log(3, "audio preroll wait");
                this.clock.wait();
                Debug.log(3, "audio preroll go!");
                this.line.start();
                return;
            }
        }
        catch (Exception exception) {
            if (this.stopping) return;
            exception.printStackTrace();
        }
    }

    public void realRun() {
        Debug.log(3, "entering audio thread");
        while (!this.stopping) {
            MediaBuffer mediaBuffer;
            block6: {
                MediaBuffer mediaBuffer2 = null;
                try {
                    mediaBuffer2 = (MediaBuffer)QueueManager.dequeue(this.queueid);
                }
                catch (InterruptedException interruptedException) {
                    if (this.stopping) continue;
                    interruptedException.printStackTrace();
                    continue;
                }
                mediaBuffer = this.plugin.decode(mediaBuffer2);
                if (mediaBuffer == null) continue;
                if (this.preQueueing) {
                    this.handlePrequeue(mediaBuffer);
                    continue;
                }
                try {
                    this.clock.checkPlay();
                    this.line.write(mediaBuffer.data, mediaBuffer.offset, mediaBuffer.length);
                    this.sampleCount += (long)(mediaBuffer.length / (2 * this.plugin.channels));
                    this.checkClockAdjust();
                }
                catch (Exception exception) {
                    if (this.stopping) break block6;
                    exception.printStackTrace();
                }
            }
            mediaBuffer.free();
        }
        Debug.log(3, "exit audio thread");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.stopping = false;
        this.queuedTime = -1;
        this.preQueue = new Vector();
        this.preQueueing = true;
        this.samplesQueued = 0L;
        this.sampleCount = 0L;
        this.nextSampleCount = 0L;
    }

    public AudioConsumer(Clock clock) {
        this.this();
        this.queueid = QueueManager.registerQueue(5);
        Debug.log(3, "audio on queue " + this.queueid);
        this.clock = clock;
    }
}

